/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.List;
import org.kapott.cryptalgs.SignatureParamSpec;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;

public class CryptUtils {
    public static final String HASH_ALG_RIPE_MD160 = "RIPEMD160";
    public static final String HASH_ALG_SHA256 = "SHA-256";
    public static final String HASH_ALG_SHA1 = "SHA-1";
    private static final List<String> HASH_OWN_PROVIDER = Arrays.asList("RIPEMD160");
    public static final String SIGN_ALG_RSA = "PKCS1_PSS";
    private static final List<String> SIGN_OWN_PROVIDER = Arrays.asList("PKCS1_PSS");
    public static final String CRYPT_ALG_AES = "AES";
    public static final String CRYPT_ALG_RSA = "RSA";
    public static final String CRYPT_ALG_AES_CBC = "AES/CBC/ISO7816-4Padding";

    public static String getSecurityProvider() {
        return HBCIUtils.getParam("kernel.security.provider");
    }

    public static final String hash(String data, String alg) throws HBCI_Exception {
        try {
            byte[] hash = CryptUtils.hash(data.getBytes("ISO-8859-1"), alg);
            return new String(hash, "ISO-8859-1");
        }
        catch (HBCI_Exception e) {
            throw e;
        }
        catch (Exception e2) {
            throw new HBCI_Exception(e2);
        }
    }

    public static final byte[] hash(byte[] data, String alg) throws HBCI_Exception {
        try {
            String provider = HASH_OWN_PROVIDER.contains(alg) ? "CryptAlgs4Java" : null;
            HBCIUtils.log("using " + alg + "/" + provider + " for generating hash of " + data.length + " bytes", 4);
            MessageDigest digest = provider != null ? MessageDigest.getInstance(alg, provider) : MessageDigest.getInstance(alg);
            return digest.digest(data);
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }

    public static final boolean verifySignature(byte[] data, byte[] signature, PublicKey key, String signAlg, String hashAlg) throws HBCI_Exception {
        try {
            String signProvider = SIGN_OWN_PROVIDER.contains(signAlg) ? "CryptAlgs4Java" : null;
            String hashProvider = HASH_OWN_PROVIDER.contains(hashAlg) ? "CryptAlgs4Java" : null;
            HBCIUtils.log("using " + signAlg + "+" + hashAlg + "/" + signProvider + "/" + hashProvider + " for verifying signature of " + data.length + " bytes", 4);
            Signature sig = signProvider != null ? Signature.getInstance(signAlg, signProvider) : Signature.getInstance(signAlg);
            SignatureParamSpec spec = new SignatureParamSpec(hashAlg, hashProvider);
            sig.setParameter(spec);
            sig.initVerify(key);
            sig.update(data);
            return sig.verify(signature);
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }

    public static final byte[] sign(byte[] data, PrivateKey key, String signAlg, String hashAlg) throws HBCI_Exception {
        try {
            String signProvider = SIGN_OWN_PROVIDER.contains(signAlg) ? "CryptAlgs4Java" : null;
            String hashProvider = HASH_OWN_PROVIDER.contains(hashAlg) ? "CryptAlgs4Java" : null;
            HBCIUtils.log("using " + signAlg + "+" + hashAlg + "/" + signProvider + "/" + hashProvider + " for generating signature of " + data.length + " bytes", 4);
            Signature sig = signProvider != null ? Signature.getInstance(signAlg, signProvider) : Signature.getInstance(signAlg);
            SignatureParamSpec spec = new SignatureParamSpec(hashAlg, hashProvider);
            sig.setParameter(spec);
            sig.initSign(key);
            sig.update(data);
            return sig.sign();
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }

    public static int getCryptDataSize(RSAPublicKey key) {
        int bits = key.getModulus().bitLength();
        int size = bits / 8;
        if (size % 8 != 0) {
            ++size;
        }
        return size;
    }

    public static byte[] padLeft(byte[] buffer, RSAPublicKey key) {
        return CryptUtils.padLeft(buffer, CryptUtils.getCryptDataSize(key));
    }

    public static byte[] padLeft(byte[] buffer, int size) {
        if (buffer.length == size) {
            return buffer;
        }
        byte[] result = buffer;
        HBCIUtils.log("left-pad " + buffer.length + " bytes to " + size + " bytes length", 5);
        if (buffer.length > size) {
            int diff = buffer.length - size;
            boolean ok = true;
            for (int i = 0; i < diff; ++i) {
                if (buffer[i] == 0) continue;
                HBCIUtils.log("byte " + i + " in data is not zero, but it should be zero", 2);
                ok = false;
            }
            if (ok) {
                HBCIUtils.log("removing " + diff + " unnecessary null-bytes from data", 4);
                result = new byte[size];
                System.arraycopy(buffer, diff, result, 0, size);
            }
        } else if (buffer.length < size) {
            int diff = size - buffer.length;
            HBCIUtils.log("prepending " + diff + " null bytes to data", 5);
            result = new byte[size];
            Arrays.fill(result, (byte)0);
            System.arraycopy(buffer, 0, result, diff, buffer.length);
        }
        return result;
    }
}

