/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.callback.HBCICallbackConsole;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;

public class HBCIBatch {
    private static final int STATE_NEED_JOBNAME = 1;
    private static final int STATE_NEED_JOBPARAMS = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        FileInputStream istream = new FileInputStream(args[0]);
        props.load(istream);
        ((InputStream)istream).close();
        HBCIUtils.init(props, new MyCallback(args));
        try (HBCIPassport passport = AbstractHBCIPassport.getInstance();){
            String version = passport.getHBCIVersion();
            HBCIHandler handler = new HBCIHandler(version.length() != 0 ? version : HBCIUtils.getParam("default.hbciversion"), passport);
            try (BufferedReader reader = new BufferedReader(new FileReader(args[2]));){
                String line;
                int state = 1;
                boolean lljob = false;
                HBCIJob job = null;
                String jobid = null;
                String customerId = null;
                Hashtable<String, Object> jobs = new Hashtable<String, Object>();
                while ((line = reader.readLine()) != null) {
                    StringTokenizer tok;
                    if ((line = line.trim()).startsWith("#")) continue;
                    if (state == 1 && line.length() != 0) {
                        String resultMode;
                        tok = new StringTokenizer(line, ":");
                        String jobname = tok.nextToken().trim();
                        if (jobname.equals("--")) {
                            customerId = tok.hasMoreTokens() ? tok.nextToken().trim() : null;
                            handler.newMsg(customerId);
                            continue;
                        }
                        if (jobname.startsWith("_")) {
                            job = handler.newLowlevelJob(jobname.substring(1));
                            lljob = true;
                            jobid = tok.nextToken().trim();
                            resultMode = "toString";
                            customerId = tok.hasMoreTokens() ? tok.nextToken().trim() : null;
                        } else {
                            job = handler.newJob(jobname);
                            lljob = false;
                            jobid = tok.nextToken().trim();
                            resultMode = tok.nextToken().trim();
                            customerId = tok.hasMoreTokens() ? tok.nextToken().trim() : null;
                        }
                        jobs.put(jobid, job);
                        jobs.put(jobid + "_resultMode", resultMode);
                        state = 2;
                        continue;
                    }
                    if (state != 2) continue;
                    if (line.length() != 0) {
                        tok = new StringTokenizer(line, "=");
                        String paramName = tok.nextToken().trim();
                        if (!tok.hasMoreTokens()) continue;
                        String paramValue = tok.nextToken().trim();
                        if (paramName.startsWith("_") != lljob) {
                            if (lljob) {
                                throw new HBCI_Exception("*** " + jobid + " is a lowlevel job, so parameter names have to start with '_'");
                            }
                            throw new HBCI_Exception("*** " + jobid + " is a highlevel job, so parameter names must not start with '_'");
                        }
                        if (lljob) {
                            paramName = paramName.substring(1);
                        }
                        if (paramValue.startsWith("<")) {
                            int len;
                            String filename = paramValue.substring(1);
                            FileInputStream fin = new FileInputStream(filename);
                            byte[] buffer = new byte[2048];
                            StringBuffer content = new StringBuffer();
                            while ((len = fin.read(buffer)) > 0) {
                                content.append(new String(buffer, 0, len, "ISO-8859-1"));
                            }
                            fin.close();
                            paramValue = content.toString();
                        }
                        job.setParam(paramName, paramValue);
                        continue;
                    }
                    job.addToQueue(customerId);
                    state = 1;
                }
                if (state == 2) {
                    job.addToQueue(customerId);
                }
                handler.execute();
                PrintWriter writer = new PrintWriter(new FileWriter(args[3]));
                PrintWriter errWriter = new PrintWriter(new FileWriter(args[3] + ".err"));
                try {
                    Enumeration jobIds = jobs.keys();
                    while (jobIds.hasMoreElements()) {
                        jobid = (String)jobIds.nextElement();
                        if (jobid.endsWith("_resultMode")) continue;
                        job = (HBCIJob)jobs.get(jobid);
                        if (job.getJobResult().isOK()) {
                            writer.println("jobid:" + jobid);
                            writer.println("job status:");
                            writer.println(job.getJobResult().getJobStatus());
                            writer.println("job result:");
                            String resultMode = (String)jobs.get(jobid + "_resultMode");
                            if (resultMode.equals("props")) {
                                Properties result = job.getJobResult().getResultData();
                                if (result != null) {
                                    Object[] keys = new ArrayList<Object>(result.keySet()).toArray(new String[0]);
                                    Arrays.sort(keys);
                                    for (int i = 0; i < keys.length; ++i) {
                                        Object name = keys[i];
                                        String value = result.getProperty((String)name);
                                        writer.println((String)name + "=" + value);
                                    }
                                }
                            } else {
                                writer.println(job.getJobResult());
                            }
                            writer.println();
                            continue;
                        }
                        errWriter.println("jobid:" + jobid);
                        errWriter.println("global status:");
                        errWriter.println(job.getJobResult().getGlobStatus().getErrorString());
                        errWriter.println("job status:");
                        errWriter.println(job.getJobResult().getJobStatus().getErrorString());
                        errWriter.println();
                    }
                }
                finally {
                    writer.close();
                    errWriter.close();
                }
            }
            finally {
                handler.close();
                passport = null;
            }
        }
    }

    private static class MyCallback
    extends HBCICallbackConsole {
        private Properties answers = new Properties();

        public MyCallback(String[] args) throws FileNotFoundException, IOException {
            FileInputStream answerFile = new FileInputStream(args[1]);
            this.answers.load(answerFile);
            answerFile.close();
            if (args.length >= 5) {
                PrintStream outStream = new PrintStream(new FileOutputStream(args[4]));
                System.setOut(outStream);
                System.setErr(outStream);
                this.setOutStream(outStream);
            }
        }

        private String getAnswer(String prop) {
            String value = this.answers.getProperty(prop);
            if (value == null) {
                throw new HBCI_Exception("Missing property '" + prop + "' in answer file!");
            }
            return value;
        }

        @Override
        public synchronized void callback(HBCIPassport passport, int reason, String msg, int datatype, StringBuffer retData) {
            switch (reason) {
                case 2: {
                    System.out.println(HBCIUtilsInternal.getLocMsg("CALLB_NEED_CHIPCARD"));
                    break;
                }
                case 3: {
                    System.out.println(HBCIUtilsInternal.getLocMsg("CALLB_NEED_HARDPIN"));
                    break;
                }
                case 4: {
                    retData.replace(0, retData.length(), this.getAnswer("softpin"));
                    break;
                }
                case 21: 
                case 22: {
                    retData.replace(0, retData.length(), this.getAnswer("passphrase"));
                    break;
                }
                case 27: {
                    retData.replace(0, retData.length(), this.getAnswer("secmech"));
                    break;
                }
                case 32: {
                    retData.replace(0, retData.length(), this.getAnswer("tanmedia"));
                    break;
                }
                case 16: {
                    retData.replace(0, retData.length(), this.getAnswer("pin"));
                    break;
                }
                case 17: 
                case 33: 
                case 34: {
                    String value = this.answers.getProperty("tanfile");
                    if (value != null) {
                        File tanFile = new File(value);
                        String tan = null;
                        for (int rounds = 0; rounds < 120; ++rounds) {
                            if (tanFile.exists()) {
                                try {
                                    BufferedReader brTest = new BufferedReader(new FileReader(tanFile));
                                    tan = brTest.readLine();
                                    if (!tan.isEmpty()) {
                                        retData.replace(0, retData.length(), tan);
                                        new FileWriter(tanFile, false).close();
                                        break;
                                    }
                                    brTest.close();
                                }
                                catch (FileNotFoundException e) {
                                    throw new HBCI_Exception(e);
                                }
                                catch (IOException e) {
                                    throw new HBCI_Exception(e);
                                }
                            }
                            try {
                                Thread.sleep(1000L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                throw new HBCI_Exception(e);
                            }
                        }
                        if (tan != null && !tan.isEmpty()) break;
                        throw new HBCI_Exception("Tan file not provided in time...");
                    }
                    retData.replace(0, retData.length(), this.getAnswer("tan"));
                    break;
                }
                case 7: {
                    retData.replace(0, retData.length(), this.getAnswer("country"));
                    break;
                }
                case 8: {
                    retData.replace(0, retData.length(), this.getAnswer("blz"));
                    break;
                }
                case 9: {
                    retData.replace(0, retData.length(), this.getAnswer("host"));
                    break;
                }
                case 10: {
                    retData.replace(0, retData.length(), this.getAnswer("port"));
                    break;
                }
                case 26: {
                    retData.replace(0, retData.length(), this.getAnswer("filter"));
                    break;
                }
                case 11: {
                    retData.replace(0, retData.length(), this.getAnswer("userid"));
                    break;
                }
                case 18: {
                    retData.replace(0, retData.length(), this.getAnswer("customerid"));
                    break;
                }
                case 23: {
                    retData.replace(0, retData.length(), this.getAnswer("sizentry"));
                    break;
                }
                case 12: {
                    retData.replace(0, retData.length(), "");
                    break;
                }
                case 13: {
                    System.out.println("please restart batch process");
                    break;
                }
                case 14: {
                    HBCIUtils.log(msg, 3);
                    break;
                }
            }
        }

        @Override
        public synchronized void status(HBCIPassport passport, int statusTag, Object[] objs) {
        }
    }
}

