/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;

public class IOUtils {
    public static void safeReplace(File origFile, File tmpFile) {
        HBCIUtils.log("saving file " + origFile, 4);
        if (origFile.exists()) {
            HBCIUtils.log("deleting old file " + origFile, 4);
            if (!origFile.delete()) {
                HBCIUtils.log("file " + origFile + " not yet deleted, waiting...", 2);
            }
        }
        int retry = 0;
        while (origFile.exists() && retry++ < 20) {
            try {
                HBCIUtils.log("wait a little bit, maybe another thread (antivirus scanner) holds a lock, file still exists", 2);
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                HBCIUtils.log("interrupted", 2);
                break;
            }
            if (origFile.exists()) continue;
            HBCIUtils.log("file now gone: " + origFile, 4);
            break;
        }
        if (origFile.exists()) {
            throw new HBCI_Exception("could not delete " + origFile);
        }
        retry = 0;
        HBCIUtils.log("renaming " + tmpFile.getName() + " to " + origFile.getName(), 4);
        while (!origFile.exists() && retry++ < 20) {
            if (!tmpFile.renameTo(origFile)) {
                HBCIUtils.log("file " + tmpFile + " not yet renamed to " + origFile + ", waiting ", 2);
            }
            if (origFile.exists()) {
                HBCIUtils.log("new file now exists: " + origFile, 4);
                break;
            }
            try {
                HBCIUtils.log("wait a little bit, maybe another thread (antivirus scanner) holds a lock, file still not renamed", 2);
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                HBCIUtils.log("interrupted", 2);
                break;
            }
        }
        if (!origFile.exists()) {
            throw new HBCI_Exception("could not rename " + tmpFile.getName() + " to " + origFile.getName());
        }
    }

    public static long copy(InputStream is, OutputStream os) throws IOException {
        int read;
        byte[] buf = new byte[4096];
        long size = 0L;
        while ((read = is.read(buf)) != -1) {
            os.write(buf, 0, read);
            size += (long)read;
        }
        return size;
    }

    public static byte[] read(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy(is, bos);
        return bos.toByteArray();
    }

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception e) {
            HBCIUtils.log(e, 4);
        }
    }

    public static String safeFilename(String filename) {
        String newName;
        if (filename == null || filename.length() == 0) {
            return filename;
        }
        File f = new File(filename).getAbsoluteFile();
        String name = f.getName();
        if ((name = name.replaceAll("[^a-zA-Z0-9_\\.-]", "")).length() > 25) {
            name = name.substring(0, 25);
        }
        if ((newName = (f = new File(f.getParentFile(), name)).getAbsolutePath()).equals(filename)) {
            return filename;
        }
        HBCIUtils.log("auto-fixed filename from " + f + " to " + newName, 4);
        return newName;
    }
}

