/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.callback.HBCICallbackConsole;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;

public final class InitAndTest {
    private static HBCIPassport passport;
    private static HBCIHandler hbciHandle;

    public static void main(String[] args) throws IOException {
        try {
            HBCIUtils.init(null, new MyCallback());
            InitAndTest.readBasicParams();
            InitAndTest.readPassportParams();
            passport = AbstractHBCIPassport.getInstance();
            InitAndTest.readHBCIVersion();
            InitAndTest.readActions();
            if (HBCIUtils.getParam("action.resetBPD").equals("1")) {
                passport.clearBPD();
            }
            if (HBCIUtils.getParam("action.resetUPD").equals("1")) {
                passport.clearUPD();
            }
            hbciHandle = new HBCIHandler(HBCIUtils.getParam("client.passport.hbciversion.default"), passport);
            InitAndTest.printSupportedGVs(hbciHandle);
            System.out.println();
            System.out.println("finished.");
            System.out.println();
        }
        finally {
            if (hbciHandle != null) {
                hbciHandle.close();
            } else if (passport != null) {
                passport.close();
            }
        }
    }

    private static void readParam(String paramName, String def, String descr) throws IOException {
        System.out.println();
        System.out.println(descr);
        System.out.println("press ENTER to accept the default; '-' to set no value for this parameter");
        System.out.print(paramName + " [" + def + "]: ");
        System.out.flush();
        String value = new BufferedReader(new InputStreamReader(System.in)).readLine();
        if (value.equals("-")) {
            value = null;
        } else if (value.length() == 0) {
            value = def;
        }
        if (value != null) {
            System.out.println(paramName + "=" + value);
            HBCIUtils.setParam(paramName, value);
        }
    }

    private static void readBasicParams() throws IOException {
        InitAndTest.readParam("client.connection.localPort", null, "local tcp-port to be used for outgoing connections");
        InitAndTest.readParam("comm.standard.socks.server", null, "SOCKS server to be used for outgoing connections (will be ignored for PIN/TAN)");
        InitAndTest.readParam("log.loglevel.default", "5", "loglevel for HBCI4Java-messages (from 0(no logging) to 5(really heavy)");
        InitAndTest.readParam("kernel.rewriter", HBCIUtils.getParam("kernel.rewriter"), "rewriter modules to be activated");
    }

    private static void readPassportParams() throws IOException {
        InitAndTest.readParam("client.passport.default", null, "enter type of media you have (Anonymous, DDV, RDHNew, RDH (deprecated), PinTan, SIZRDHFile or RDHXFile)");
        String type = HBCIUtils.getParam("client.passport.default", "");
        if (type.equals("Anonymous")) {
            InitAndTest.readParam("client.passport.Anonymous.filename", "passport_anon.dat", "filename to be used for your HBCI4Java keyfile.");
            InitAndTest.readParam("client.passport.Anonymous.init", "1", "never change this value!");
        } else if (type.equals("DDV")) {
            InitAndTest.readParam("client.passport.DDV.path", "./", "the path where to store a file to cash information about your HBCI account");
            InitAndTest.readParam("client.passport.DDV.libname.ddv", "/home/kleiner/projects/hbci2/chipcard/lib/libhbci4java-card-linux.so", "the name of the library needed to use the CTAPI interface of your chipcard terminal");
            InitAndTest.readParam("client.passport.DDV.libname.ctapi", "/usr/lib/libctapi-cyberjack.so", "the name of the library containing the CTAPI interface to your chipcard terminal");
            InitAndTest.readParam("client.passport.DDV.port", "1", "the port to which your chipcard terminal is connected (in most cases 1, 0 or 2)");
            InitAndTest.readParam("client.passport.DDV.ctnumber", "0", "the logical number for your chipcard terminal, can be 0 in most cases");
            InitAndTest.readParam("client.passport.DDV.usebio", "0", "use the biometric interface of Reiner-SCT chipcard terminals (0 or 1)");
            InitAndTest.readParam("client.passport.DDV.softpin", "0", "use the keypad of your chipcard terminal (0) or your PC-keyboard (1) to enter the PIN for your HBCI chipcard");
            InitAndTest.readParam("client.passport.DDV.entryidx", "1", "enter the index, which HBCI account stored on the card should be used");
        } else if (type.equals("RDH")) {
            InitAndTest.readParam("client.passport.RDH.filename", "my_passport.dat", "filename to be used for your HBCI4Java keyfile. DONT LOOSE THIS FILE!");
            InitAndTest.readParam("client.passport.RDH.init", "1", "never change this value!");
        } else if (type.equals("RDHNew")) {
            InitAndTest.readParam("client.passport.RDHNew.filename", "my_passport.dat", "filename to be used for your HBCI4Java keyfile. DONT LOOSE THIS FILE!");
            InitAndTest.readParam("client.passport.RDHNew.init", "1", "never change this value!");
        } else if (type.equals("PinTan")) {
            InitAndTest.readParam("client.passport.PinTan.filename", "my_passport_pintan.dat", "filename to be used for your PIN/TAN keyfile");
            InitAndTest.readParam("client.passport.PinTan.checkcert", "1", "whether to check the HTTPS-certificate of the server (1) or not (0)");
            InitAndTest.readParam("client.passport.PinTan.certfile", null, "filename with a SSL-certificate for HTTPS-communication; leave blank when you don't want to check the certificate or when the certificate can be checked with the java-builtin CA database");
            InitAndTest.readParam("client.passport.PinTan.proxy", null, "host:port for proxy server to be used; leave blank when you want direct connections to be made");
            InitAndTest.readParam("client.passport.PinTan.proxyuser", null, "when you need proxy authentication enter the username here; leave empty to be queried on demand");
            InitAndTest.readParam("client.passport.PinTan.proxypass", null, "when you need proxy authentication enter the passphrase here; leave empty to be queried on demand");
            InitAndTest.readParam("client.passport.PinTan.init", "1", "never change this value!");
        } else if (type.equals("SIZRDHFile")) {
            InitAndTest.readParam("client.passport.SIZRDHFile.filename", "secret.key", "filename of SIZ-RDH-keyfile to be used. MAKE A BACKUP OF THIS FILE BEFORE USE!");
            InitAndTest.readParam("client.passport.SIZRDHFile.libname", "/usr/lib/libhbci4java-sizrdh.so", "filename of native library for accessing SIZ RDH files");
            InitAndTest.readParam("client.passport.SIZRDHFile.init", "1", "never change this value!");
        } else if (type.equals("RDHXFile")) {
            InitAndTest.readParam("client.passport.RDHXFile.filename", "secret.key", "filename of SIZ-RDH2-keyfile to be used. MAKE A BACKUP OF THIS FILE BEFORE USE!");
            InitAndTest.readParam("client.passport.RDHXFile.init", "1", "never change this value!");
        }
    }

    private static void readHBCIVersion() throws IOException {
        String pversion = passport.getHBCIVersion();
        InitAndTest.readParam("client.passport.hbciversion.default", pversion.length() != 0 ? pversion : "210", "the hbci-version to be used; may be '201', '210', '220', '300' or 'plus'");
    }

    private static void readActions() throws IOException {
        InitAndTest.readParam("action.resetBPD", "1", "reset and refetch BPD (1/0)");
        InitAndTest.readParam("action.resetUPD", "1", "reset and refetch UPD (1/0)");
    }

    private static void printSupportedGVs(HBCIHandler handle) {
        String name;
        Object gvcode;
        int i;
        Properties gvcodes = InitAndTest.getGVCodes();
        Object[] codes = gvcodes.keySet().toArray(new String[0]);
        Arrays.sort(codes);
        System.out.println();
        System.out.println("lowlevel GVs supported by institute and HBCI4Java:");
        for (i = 0; i < codes.length; ++i) {
            gvcode = codes[i];
            name = gvcodes.getProperty((String)gvcode);
            if (name.startsWith("Template")) continue;
            System.out.println("  " + (String)gvcode + " (" + name + ")");
        }
        System.out.println();
        System.out.println("lowlevel GVs supported by institute but unknown to HBCI4Java:");
        for (i = 0; i < codes.length; ++i) {
            gvcode = codes[i];
            name = gvcodes.getProperty((String)gvcode);
            if (!name.startsWith("Template")) continue;
            System.out.println("  " + (String)gvcode);
        }
    }

    private static Properties getGVCodes() {
        Properties ret = new Properties();
        Properties bpd = passport.getBPD();
        Enumeration<?> e = bpd.propertyNames();
        while (e.hasMoreElements()) {
            String version;
            String key = (String)e.nextElement();
            if (!key.startsWith("Params") || !key.endsWith(".SegHead.code")) continue;
            String gvcode = bpd.getProperty(key);
            int dotPos = key.indexOf(46);
            int dotPos2 = key.indexOf(46, dotPos + 1);
            String gvname = key.substring(dotPos + 1, dotPos2);
            int len = gvname.length();
            int versionPos = -1;
            for (int i = len - 1; i >= 0; --i) {
                char ch = gvname.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                versionPos = i + 1;
                break;
            }
            if ((version = gvname.substring(versionPos)).length() != 0) {
                gvname = gvname.substring(0, versionPos - 3);
            }
            ret.setProperty(gvcode, gvname);
        }
        return ret;
    }

    private static class MyCallback
    extends HBCICallbackConsole {
        private MyCallback() {
        }

        @Override
        public synchronized void status(HBCIPassport passport, int statusTag, Object[] o) {
        }
    }
}

