/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.util.ArrayList;
import java.util.Collection;

public class ObjectFactory {
    protected final Collection<Object> freeObjects = new ArrayList<Object>();
    protected final Collection<Object> usedObjects = new ArrayList<Object>();
    private final int maxPoolSize;
    protected int currentPoolSize;

    public ObjectFactory() {
        this(10);
    }

    public ObjectFactory(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        this.currentPoolSize = 0;
    }

    public synchronized Object getFreeObject() {
        if (this.freeObjects.isEmpty()) {
            return null;
        }
        Object ret = this.freeObjects.iterator().next();
        this.freeObjects.remove(ret);
        --this.currentPoolSize;
        return ret;
    }

    public synchronized void addToUsedPool(Object o) {
        if (o != null && this.currentPoolSize < this.maxPoolSize) {
            this.usedObjects.add(o);
            ++this.currentPoolSize;
        }
    }

    public synchronized void addToFreePool(Object o) {
        if (o != null && this.currentPoolSize < this.maxPoolSize) {
            this.freeObjects.add(o);
            ++this.currentPoolSize;
        }
    }

    public synchronized void unuseObject(Object o) {
        if (this.usedObjects.remove(o)) {
            this.freeObjects.add(o);
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("used:").append(this.usedObjects.size()).append(" free:").append(this.freeObjects.size()).append(" maxsize:").append(this.maxPoolSize);
        return ret.toString();
    }

    public synchronized Collection<Object> getUsedObjects() {
        return this.usedObjects;
    }

    public synchronized Collection<Object> getFreeObjects() {
        return this.freeObjects;
    }
}

