/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ShowCumulatedLowlevelParams {
    private static void extractParams(Document doc, Element node, String path, List<String> params) {
        NodeList childs = node.getChildNodes();
        int l = childs.getLength();
        for (int i = 0; i < l; ++i) {
            Node child = childs.item(i);
            if (child.getNodeType() != 1) continue;
            Element ref = (Element)child;
            String refnode = ref.getNodeName();
            String reftype = ref.getAttribute("type");
            String refname = ref.getAttribute("name");
            String refbez = refname != null && refname.length() != 0 ? refname : reftype;
            String localPath = path;
            if (localPath.length() != 0) {
                localPath = localPath + ".";
            }
            localPath = localPath + refbez;
            if (refnode.equals("DE")) {
                if (params.contains(localPath)) continue;
                params.add(localPath);
                continue;
            }
            if (!refnode.equals("DEG")) continue;
            Element def = doc.getElementById(reftype);
            if (def == null) {
                String p = localPath + " (+)";
                if (params.contains(p)) continue;
                params.add(p);
                continue;
            }
            ShowCumulatedLowlevelParams.extractParams(doc, def, localPath, params);
        }
    }

    public static void main(String[] args) throws Exception {
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        fac.setIgnoringComments(true);
        fac.setIgnoringElementContentWhitespace(true);
        fac.setNamespaceAware(false);
        fac.setValidating(false);
        DocumentBuilder builder = fac.newDocumentBuilder();
        File f = new File(args[0]);
        Document doc = builder.parse(f);
        Element root = doc.getDocumentElement();
        NodeList segdefs = root.getElementsByTagName("SEGdef");
        int l = segdefs.getLength();
        Hashtable<String, ArrayList<String>> paramsByJob = new Hashtable<String, ArrayList<String>>();
        for (int i = 0; i < l; ++i) {
            Element segdef = (Element)segdefs.item(i);
            String segdefid = segdef.getAttribute("id");
            String segcode = null;
            String segversion = null;
            NodeList values = segdef.getElementsByTagName("value");
            int l2 = values.getLength();
            for (int j = 0; j < l2; ++j) {
                Element value = (Element)values.item(j);
                String path = value.getAttribute("path");
                if (path.equals("SegHead.code")) {
                    segcode = value.getFirstChild().getNodeValue();
                    continue;
                }
                if (!path.equals("SegHead.version")) continue;
                segversion = value.getFirstChild().getNodeValue();
            }
            if (segcode == null || segversion == null) {
                System.out.println("warning: SEGdef with id " + segdefid + " has no segcode or segversion");
                continue;
            }
            String plainJobName = segdefid.substring(0, segdefid.length() - segversion.length());
            ArrayList<String> params = (ArrayList<String>)paramsByJob.get(plainJobName);
            if (params == null) {
                params = new ArrayList<String>();
                paramsByJob.put(plainJobName, params);
            }
            ShowCumulatedLowlevelParams.extractParams(doc, segdef, "", params);
        }
        Object[] jobnames = paramsByJob.keySet().toArray(new String[0]);
        Arrays.sort(jobnames);
        for (Object jobname : jobnames) {
            System.out.println((String)jobname + ":");
            List params = (List)paramsByJob.get(jobname);
            Object[] _params = params.toArray(new String[0]);
            Arrays.sort(_params);
            int l2 = _params.length;
            for (int j = 0; j < l2; ++j) {
                System.out.println("  " + (String)_params[j]);
            }
        }
    }
}

