/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc.model;

import java.lang.annotation.Annotation;
import java.util.Objects;
import org.ariia.mvc.annotation.HeaderValue;
import org.ariia.mvc.annotation.PathVariable;
import org.ariia.mvc.annotation.RequestBody;
import org.ariia.mvc.annotation.RequestParam;

public class ParameterInfo {
    private Integer index;
    private String name;
    private Annotation annotation;
    private Class<?> parameterType;

    public Integer getIndex() {
        return this.index;
    }

    public String name() {
        return this.name;
    }

    public PathVariable asPathVariable() {
        return (PathVariable)this.annotation;
    }

    public RequestBody asRequestBody() {
        return (RequestBody)this.annotation;
    }

    public RequestParam asRequestParam() {
        return (RequestParam)this.annotation;
    }

    public HeaderValue asHeaderValue() {
        return (HeaderValue)this.annotation;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    private boolean hasAnnotationType(Class<? extends Annotation> annotationClass) {
        return Objects.nonNull(this.annotation) && this.annotation.annotationType().equals(annotationClass);
    }

    public boolean isPathVariable() {
        return this.hasAnnotationType(PathVariable.class);
    }

    public boolean isRequestBody() {
        return this.hasAnnotationType(RequestBody.class);
    }

    public boolean isRequestParam() {
        return this.hasAnnotationType(RequestParam.class);
    }

    public boolean isHeaderValue() {
        return this.hasAnnotationType(HeaderValue.class);
    }

    public String toString() {
        return "ParameterInfo[ " + this.index + ", " + this.name + ", " + this.annotation + ", " + this.parameterType + "]";
    }

    public static class Builder {
        private Integer index;
        private String name;
        private Annotation annotation;
        private Class<?> parameterType;

        public Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder annotation(Annotation annotation) {
            this.annotation = annotation;
            return this;
        }

        public Builder parameterType(Class<?> parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        public ParameterInfo build() {
            ParameterInfo info = new ParameterInfo();
            info.index = this.index;
            info.name = this.name;
            info.annotation = this.annotation;
            info.parameterType = this.parameterType;
            return info;
        }
    }
}

