/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc.resource;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import org.ariia.mvc.resource.MimeType;

public interface StreamHandler {
    default public void handelStreamAndSetFileName(HttpExchange exchange, String filename, InputStream stream) throws IOException {
        Headers responseHeaders = exchange.getResponseHeaders();
        this.setFileName(responseHeaders, filename);
        this.handelStream(exchange, filename, stream);
    }

    default public void setFileName(Headers responseHeaders, String filename) throws IOException {
        filename = "attachment; filename=\"" + filename + "\"";
        responseHeaders.put("Content-Disposition", Collections.singletonList(filename));
    }

    default public void setContentType(Headers responseHeaders, String filename) throws IOException {
        responseHeaders.put("Content-Type", Collections.singletonList(MimeType.getMimeForFileName(filename)));
    }

    default public void setContentLength(Headers responseHeaders, long start, long end, long length) throws IOException {
        String contentLength = "bytes " + start + "-" + end + "/" + length;
        responseHeaders.set("Content-Length", contentLength);
    }

    default public void handelPlaneStream(HttpExchange exchange, String filename, InputStream stream) throws IOException {
        Headers responseHeaders = exchange.getResponseHeaders();
        this.setFileName(responseHeaders, filename);
        this.setContentType(responseHeaders, filename);
        this.writeToOutputStream(exchange, stream);
        stream.close();
        exchange.close();
    }

    default public void handelStream(HttpExchange exchange, String filename, InputStream stream) throws IOException {
        Headers responseHeaders = exchange.getResponseHeaders();
        this.setContentType(responseHeaders, filename);
        Headers requestHeaders = exchange.getRequestHeaders();
        OutputStream responseBody = exchange.getResponseBody();
        boolean supportGZip = false;
        for (String encoding : (List)requestHeaders.getOrDefault("Accept-Encoding", new ArrayList(0))) {
            if (Objects.isNull(encoding) || !encoding.contains("gzip")) continue;
            supportGZip = true;
            break;
        }
        if (!supportGZip) {
            this.writeToOutputStream(exchange, stream);
        } else if (stream.available() - 0x200000 < 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            byte[] bs = new byte[512];
            int read = 0;
            while ((read = stream.read(bs)) > 0) {
                gzip.write(bs, 0, read);
            }
            gzip.flush();
            gzip.close();
            this.writeGZipStream(exchange, out.toByteArray(), responseHeaders);
        } else {
            this.writeGZipStream(exchange, stream, responseBody, responseHeaders);
        }
        stream.close();
        exchange.close();
    }

    default public void writeToOutputStream(HttpExchange exchange, InputStream stream) throws IOException {
        exchange.sendResponseHeaders(200, stream.available());
        byte[] bs = new byte[512];
        int read = 0;
        while ((read = stream.read(bs)) > 0) {
            exchange.getResponseBody().write(bs, 0, read);
        }
        exchange.getResponseBody().flush();
    }

    default public void writeGZipStream(HttpExchange exchange, byte[] bytes, Headers responseHeaders) throws IOException {
        responseHeaders.put("Content-Encoding", Collections.singletonList("gzip"));
        exchange.sendResponseHeaders(200, bytes.length);
        exchange.getResponseBody().write(bytes, 0, bytes.length);
        exchange.getResponseBody().flush();
    }

    default public void writeGZipStream(HttpExchange exchange, InputStream stream, OutputStream responseBody, Headers responseHeaders) throws IOException {
        responseHeaders.put("Content-Encoding", Collections.singletonList("gzip"));
        exchange.sendResponseHeaders(200, 0L);
        GZIPOutputStream gzip = new GZIPOutputStream(responseBody);
        byte[] bs = new byte[512];
        int read = 0;
        while ((read = stream.read(bs)) > 0) {
            gzip.write(bs, 0, read);
            gzip.flush();
        }
        gzip.close();
    }

    default public void handelPartStream(HttpExchange exchange, String filename, InputStream stream, long start, long end, long length) throws IOException {
        Headers responseHeaders = exchange.getResponseHeaders();
        this.setFileName(responseHeaders, filename);
        this.setContentType(responseHeaders, filename);
        this.setContentLength(responseHeaders, start, end, length);
        exchange.sendResponseHeaders(206, end - start);
        byte[] bs = new byte[512];
        int read = 0;
        while ((read = stream.read(bs)) > 0) {
            exchange.getResponseBody().write(bs, 0, read);
        }
        exchange.getResponseBody().flush();
        stream.close();
        exchange.close();
    }
}

