/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.ariia.mvc.resource.RouterResourceHandler;
import org.ariia.mvc.router.Routes;

public class StreamResourceHandler
extends RouterResourceHandler {
    private String resourceLocation;

    public StreamResourceHandler() {
        this("/static", "/index.html", new Routes("/"));
    }

    public StreamResourceHandler(String resourceLocation, Routes routes) {
        this(resourceLocation, "/index.html", routes);
    }

    public StreamResourceHandler(String resourceLocation, String indexFile, Routes routes) {
        super(indexFile, routes);
        this.resourceLocation = Objects.requireNonNull(resourceLocation);
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    protected InputStream getResourceAsStream(String filename) throws IOException {
        InputStream stream = this.getClass().getResourceAsStream(this.resourceLocation + filename);
        if (Objects.isNull(stream)) {
            throw new IOException("no resource with this name is found");
        }
        return stream;
    }
}

