/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc.router;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.ariia.mvc.router.RESTfulRouter;

public class RESTFulContext
implements HttpHandler {
    protected String context;
    protected HttpServer server;
    protected Set<RESTfulRouter> restfulRouters;

    public RESTFulContext(HttpServer server) {
        this("/", server);
    }

    public RESTFulContext(String context, HttpServer server) {
        this.context = Objects.requireNonNull(context);
        this.server = Objects.requireNonNull(server);
        this.server.createContext(context, this);
        this.restfulRouters = new HashSet<RESTfulRouter>();
    }

    protected RESTfulRouter subscribeRouter(String router, String method) {
        String regex = '^' + router.replaceAll(":(?:.[a-zA-Z0-9]*)", "(?:.*)");
        RESTfulRouter resTfulRouter = new RESTfulRouter(this, method, router, regex);
        this.restfulRouters.add(resTfulRouter);
        return resTfulRouter;
    }

    public RESTfulRouter get(String router) {
        return this.subscribeRouter(router, "GET");
    }

    public RESTfulRouter head(String router) {
        return this.subscribeRouter(router, "HEAD");
    }

    public RESTfulRouter post(String router) {
        return this.subscribeRouter(router, "POST");
    }

    public RESTfulRouter put(String router) {
        return this.subscribeRouter(router, "PUT");
    }

    public RESTfulRouter delete(String router) {
        return this.subscribeRouter(router, "DELETE");
    }

    public RESTfulRouter patch(String router) {
        return this.subscribeRouter(router, "PATCH");
    }

    public RESTfulRouter options(String router) {
        return this.subscribeRouter(router, "OPTIONS");
    }

    public RESTfulRouter trace(String router) {
        return this.subscribeRouter(router, "TRACE");
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String uri = exchange.getRequestURI().toString();
        String contextPath = uri.replaceFirst(this.context, "");
        Stream stream = this.restfulRouters.stream();
        stream.filter(restful -> exchange.getRequestMethod().equalsIgnoreCase(restful.getMethod()) || exchange.getRequestMethod().equalsIgnoreCase("*")).filter(restful -> contextPath.matches(restful.getRegex())).limit(1L).forEach(restful -> {
            try {
                restful.getHandler().handle(exchange);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

