/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc.router;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Routes {
    private String path;
    private List<Routes> children;

    public Routes(String path) {
        this.path = Objects.requireNonNull(path);
        this.children = new ArrayList<Routes>();
    }

    public Routes(String path, String ... children) {
        this(path);
        this.routes(children);
    }

    public Routes(String path, Routes ... children) {
        this(path);
        this.routes(children);
    }

    public Routes routes(String ... children) {
        for (String child : children) {
            this.children.add(new Routes(child));
        }
        return this;
    }

    public Routes routes(Routes ... children) {
        for (Routes child : children) {
            this.children.add(child);
        }
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public List<Routes> getChildren() {
        return this.children;
    }

    public List<String> paths() {
        return this.paths(this);
    }

    private List<String> paths(Routes root) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(root.path);
        for (Routes route : root.children) {
            for (String subPath : route.paths()) {
                paths.add(this.path + '/' + subPath);
            }
        }
        return paths;
    }

    public Stream<String> childRoutes() {
        return this.children.stream().map(this::paths).flatMap(Collection::stream);
    }

    public List<String> getChildRoutes() {
        return this.children.stream().map(this::paths).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean lookupRoute(String path) {
        if (Objects.isNull(path)) {
            return false;
        }
        if (this.path.equals("**")) {
            return true;
        }
        if (path.startsWith(this.path)) {
            if (Objects.equals(this.path, path) || Objects.equals(this.path + '/', path)) {
                return true;
            }
            String subPath = path.replaceFirst(this.path, "");
            if (subPath.startsWith("/")) {
                subPath = subPath.substring(1);
            }
            for (Routes route : this.children) {
                if (!route.lookupRoute(subPath)) continue;
                return true;
            }
        }
        return false;
    }
}

