/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc.sse;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ariia.mvc.sse.MessageEvent;
import org.ariia.mvc.sse.SourceEvent;
import org.ariia.mvc.sse.SseCloseException;
import org.ariia.mvc.sse.Subscriber;

public class EventBroadcast
implements SourceEvent {
    List<Subscriber> subscribers;

    public EventBroadcast() {
        this(new LinkedList<Subscriber>());
    }

    public EventBroadcast(List<Subscriber> subscribers) {
        this.subscribers = subscribers;
    }

    @Override
    public void subscribe(Subscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    @Override
    public void send(String event, String data) {
        MessageEvent messageEvent = new MessageEvent.Builder().event(event).data(data).build();
        this.send(messageEvent);
    }

    @Override
    public void send(MessageEvent event) {
        Iterator<Subscriber> iterator = this.subscribers.iterator();
        while (iterator.hasNext()) {
            Subscriber subscriber = iterator.next();
            try {
                subscriber.message(event);
            }
            catch (SseCloseException e) {
                iterator.remove();
            }
        }
    }

    @Override
    public void send(String event) {
        MessageEvent messageEvent = new MessageEvent.Builder().event(event).build();
        this.send(messageEvent);
    }

    @Override
    public void send(String event, String data, Integer retry) {
        MessageEvent messageEvent = new MessageEvent.Builder().event(event).data(data).retry(retry).build();
        this.send(messageEvent);
    }

    @Override
    public void send(String event, String data, Integer retry, String id) {
        MessageEvent messageEvent = new MessageEvent.Builder().event(event).data(data).retry(retry).id(id).build();
        this.send(messageEvent);
    }
}

