/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc.sse;

import java.util.Objects;
import org.ariia.mvc.sse.MessageEvent;
import org.ariia.mvc.sse.SourceEvent;

public class EventProvider {
    private String eventName;
    private Integer id = 0;
    private SourceEvent sourceEvent;

    public EventProvider(String event, SourceEvent sourceEvent) {
        this.eventName = Objects.requireNonNull(event);
        this.sourceEvent = Objects.requireNonNull(sourceEvent);
    }

    private void send(MessageEvent event) {
        this.sourceEvent.send(event);
    }

    public void send(String data) {
        this.id = this.id + 1;
        MessageEvent messageEvent = new MessageEvent.Builder().event(this.eventName).data(data).id(String.valueOf(this.id)).build();
        this.send(messageEvent);
    }

    public void send(String data, Integer retry) {
        this.id = this.id + 1;
        MessageEvent messageEvent = new MessageEvent.Builder().event(this.eventName).data(data).retry(retry).id(String.valueOf(this.id)).build();
        this.send(messageEvent);
    }
}

