/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc.sse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.ariia.mvc.sse.MessageEvent;
import org.ariia.mvc.sse.SseCloseException;
import org.ariia.mvc.sse.Subscriber;

public class EventSubscriber
implements Subscriber {
    private final OutputStream outputStream;

    public EventSubscriber(OutputStream outputStream) {
        this.outputStream = Objects.requireNonNull(outputStream);
    }

    @Override
    public void message(MessageEvent event) throws SseCloseException {
        String eventResponse = event.toString();
        try {
            this.outputStream.write(eventResponse.getBytes(StandardCharsets.UTF_8));
            this.outputStream.flush();
        }
        catch (IOException e) {
            try {
                this.outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SseCloseException(e);
        }
    }

    @Override
    public void message(String event) throws SseCloseException {
        String eventResponse = new MessageEvent.Builder().event(event).build().toString();
        this.message(eventResponse);
    }

    @Override
    public void message(String event, String data) throws SseCloseException {
        String eventResponse = new MessageEvent.Builder().event(event).data(data).build().toString();
        this.message(eventResponse);
    }

    @Override
    public void message(String event, String data, Integer retry) throws SseCloseException {
        String eventResponse = new MessageEvent.Builder().event(event).data(data).retry(retry).build().toString();
        this.message(eventResponse);
    }

    @Override
    public void message(String event, String data, Integer retry, String id) throws SseCloseException {
        String eventResponse = new MessageEvent.Builder().event(event).data(data).retry(retry).id(id).build().toString();
        this.message(eventResponse);
    }
}

