/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc.sse;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.Objects;
import org.ariia.mvc.sse.EventSubscriber;
import org.ariia.mvc.sse.MessageEvent;
import org.ariia.mvc.sse.SourceEvent;

public final class ServerSideEventHandler
implements HttpHandler {
    private final SourceEvent event;

    public ServerSideEventHandler(SourceEvent event) {
        this.event = Objects.requireNonNull(event);
    }

    public SourceEvent getEvent() {
        return this.event;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        if (!"GET".equalsIgnoreCase(exchange.getRequestMethod())) {
            exchange.sendResponseHeaders(405, -1L);
            return;
        }
        String accept = exchange.getRequestHeaders().getFirst("Accept");
        if (!accept.equals("text/event-stream")) {
            exchange.sendResponseHeaders(405, -1L);
            return;
        }
        exchange.getResponseHeaders().add("Content-Type", "text/event-stream");
        exchange.getResponseHeaders().add("Character-Encoding", "UTF-8");
        exchange.getResponseHeaders().add("Cache-Control", "no-cache");
        exchange.getResponseHeaders().add("Connection", "keep-alive");
        exchange.sendResponseHeaders(200, 0L);
        EventSubscriber subscriber = new EventSubscriber(exchange.getResponseBody());
        subscriber.message(MessageEvent.KeepAlive);
        this.event.subscribe(subscriber);
    }
}

