/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.aspect;

import com.github.shuaidd.enums.ErrorCode;
import com.github.shuaidd.exception.WeChatException;
import com.github.shuaidd.support.WeChatManager;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

@Aspect
@Component
public class WeChatClientAspect {
    private final WeChatManager weChatManager;
    private static final Logger log = LoggerFactory.getLogger(WeChatClientAspect.class);

    @Autowired
    public WeChatClientAspect(WeChatManager weChatManager) {
        this.weChatManager = weChatManager;
    }

    @Around(value="execution(* com.github.shuaidd.client.*Client.*(..))")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        try {
            result = joinPoint.proceed();
        }
        catch (Throwable throwable) {
            if (throwable instanceof WeChatException || throwable.getCause() instanceof WeChatException) {
                WeChatException w;
                WeChatException weChatException = w = throwable instanceof WeChatException ? (WeChatException)throwable : (WeChatException)throwable.getCause();
                if (w.getErrorCode() != null && this.needRetry(w.getErrorCode().getErrorCode())) {
                    String applicationName;
                    if (log.isDebugEnabled()) {
                        log.debug("\u91cd\u8bd5\u4e00\u6b21\u5fae\u4fe1\u8c03\u7528\uff1a{}", (Object)w.getErrorCode().getErrorCode());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(applicationName = this.getApplicationName(joinPoint)))) {
                        this.weChatManager.tokenService().clearAccessToken(applicationName);
                    }
                    result = joinPoint.proceed();
                }
                throw throwable.getCause();
            }
            throw throwable;
        }
        return result;
    }

    private String getApplicationName(ProceedingJoinPoint joinPoint) {
        String applicationName = null;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        PostMapping postMapping = method.getAnnotation(PostMapping.class);
        if (postMapping != null) {
            Object[] objects;
            String[] headers = postMapping.headers();
            if (headers.length > 0 && (objects = joinPoint.getArgs()).length > 0) {
                applicationName = (String)objects[objects.length - 1];
            }
        } else {
            Object[] objects;
            String[] headers;
            GetMapping getMapping = method.getAnnotation(GetMapping.class);
            if (getMapping != null && (headers = getMapping.headers()).length > 0 && (objects = joinPoint.getArgs()).length > 0) {
                applicationName = (String)objects[objects.length - 1];
            }
        }
        return applicationName;
    }

    private boolean needRetry(String errorCode) {
        boolean needRetry = false;
        if (ErrorCode.ERROR_CODE_40014.getErrorCode().equals(errorCode)) {
            needRetry = true;
        }
        if (ErrorCode.ERROR_CODE_41001.getErrorCode().equals(errorCode)) {
            needRetry = true;
        }
        if (ErrorCode.ERROR_CODE_42001.getErrorCode().equals(errorCode)) {
            needRetry = true;
        }
        return needRetry;
    }
}

