/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.client.decoder;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.shuaidd.enums.ErrorCode;
import com.github.shuaidd.exception.WeChatException;
import com.github.shuaidd.response.AbstractBaseResponse;
import feign.Response;
import feign.jackson.JacksonDecoder;
import java.io.IOException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomJacksonDecoder
extends JacksonDecoder {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public Object decode(Response response, Type type) throws IOException {
        Object result = super.decode(response, type);
        if (result instanceof AbstractBaseResponse) {
            AbstractBaseResponse abstractBaseResponse = (AbstractBaseResponse)result;
            if (abstractBaseResponse.getErrCode().equals(ErrorCode.ERROR_CODE_0.getErrorCode())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u4ece\u63a5\u53e3 {} \u83b7\u53d6\u5230\u4f01\u4e1a\u5fae\u4fe1\u7684\u54cd\u5e94\u6570\u636e--->\n {}", (Object)response.request().requestTemplate().path(), (Object)objectMapper.writeValueAsString(result));
                }
                return result;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u83b7\u53d6\u5230\u7684\u8fd4\u56de\u7ed3\u679c\u72b6\u6001--{}--{}", (Object)abstractBaseResponse.getErrCode(), (Object)abstractBaseResponse.getErrMsg());
            }
            throw new WeChatException(abstractBaseResponse.getErrMsg(), ErrorCode.errorCode((String)abstractBaseResponse.getErrCode()));
        }
        return result;
    }

    static {
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

