/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.client.decoder;

import com.github.shuaidd.client.decoder.CustomJacksonDecoder;
import com.github.shuaidd.enums.ErrorCode;
import com.github.shuaidd.exception.WeChatException;
import feign.FeignException;
import feign.Response;
import feign.codec.Decoder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class WeChatMediaDecoder
implements Decoder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Decoder delegate = new CustomJacksonDecoder();
    public static final String RESPONSE_ENTITY_PACKAGE = "org.springframework.http.ResponseEntity<byte[]>";
    public static final String FILE_PACKAGE = "java.io.File";

    public Object decode(Response response, Type type) throws FeignException, IOException {
        if (type.getTypeName().equals(RESPONSE_ENTITY_PACKAGE)) {
            byte[] body = IOUtils.toByteArray((InputStream)response.body().asInputStream());
            MultiValueMap<String, String> headers = this.checkDownloadHeaders(response);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u4e0b\u8f7d\u7684\u6587\u4ef6\u5927\u5c0f\u4e3a--{}", (Object)body.length);
            }
            return new ResponseEntity((Object)body, headers, HttpStatus.OK);
        }
        if (FILE_PACKAGE.equals(type.getTypeName())) {
            File downloadFile;
            String path;
            InputStream inputStream = IOUtils.toBufferedInputStream((InputStream)response.body().asInputStream());
            MultiValueMap<String, String> headers = this.checkDownloadHeaders(response);
            String fileName = ((String)((List)headers.get((Object)"content-disposition")).get(0)).split(";")[2].split("=")[1].replace("\"", "");
            String property = "java.io.tmpdir";
            String filePath = System.getProperty(property);
            Collection headCol = (Collection)response.request().headers().get("downloadFilePath");
            if (headCol != null && headCol.size() > 0 && StringUtils.isNotEmpty((CharSequence)(path = (String)headCol.iterator().next()))) {
                filePath = path;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u5f85\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84\u662f--{}---\u4f01\u4e1a\u5fae\u4fe1\u7aef\u6587\u4ef6\u540d\u79f0-{}", (Object)filePath, (Object)fileName);
            }
            if ((downloadFile = new File(filePath)).isDirectory()) {
                String realPath = Paths.get(filePath, fileName).toString();
                downloadFile = new File(realPath);
            }
            FileOutputStream outputStream = new FileOutputStream(downloadFile);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            return downloadFile;
        }
        return this.delegate.decode(response, type);
    }

    private MultiValueMap<String, String> checkDownloadHeaders(Response response) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        for (String key : response.headers().keySet()) {
            headers.put((Object)key, new LinkedList((Collection)response.headers().get(key)));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u8bf7\u6c42\u5934\u4fe1\u606f--{}-->{}", (Object)key, ((Collection)response.headers().get(key)).iterator().next());
            }
            if (!"error-code".equals(key)) continue;
            String errorCode = (String)((Collection)response.headers().get(key)).iterator().next();
            String errorMsg = (String)((Collection)response.headers().get("error-msg")).iterator().next();
            if (ErrorCode.ERROR_CODE_0.getErrorCode().equals(errorCode)) continue;
            this.logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25-->error-code-->{}-error-msg--->{}", (Object)errorCode, (Object)errorMsg);
            throw new WeChatException(errorMsg, ErrorCode.errorCode((String)errorCode));
        }
        return headers;
    }
}

