/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.client.interceptor;

import com.github.shuaidd.support.WeChatContextHolder;
import com.github.shuaidd.support.WeChatManager;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatInterceptor
implements RequestInterceptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void apply(RequestTemplate template) {
        if (!template.url().startsWith("/gettoken")) {
            String realApp;
            String app = "";
            Collection headerApp = (Collection)template.headers().get("app");
            if (CollectionUtils.isNotEmpty((Collection)headerApp) && StringUtils.isNotEmpty((CharSequence)(realApp = (String)new ArrayList(headerApp).get(0)))) {
                app = realApp;
            }
            if (StringUtils.isEmpty((CharSequence)app)) {
                throw new RuntimeException("\u8bf7\u6c42\u672a\u4f20\u9012\u5e94\u7528\u540d\uff0c\u65e0\u6cd5\u8c03\u8d77\u63a5\u53e3");
            }
            WeChatManager weChatManager = WeChatContextHolder.getWeChatManager();
            String accessToken = weChatManager.tokenService().getAccessToken(app);
            template.query("access_token", new String[]{accessToken});
            if (weChatManager.properties().getDebugMode().booleanValue()) {
                template.query("debug", new String[]{"1"});
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\u5b9e\u9645\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)template.url());
        }
    }
}

