/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.service;

import com.github.shuaidd.client.AddressBookClient;
import com.github.shuaidd.client.AuthClient;
import com.github.shuaidd.client.EfficiencyToolClient;
import com.github.shuaidd.client.ElectronicInvoiceClient;
import com.github.shuaidd.client.EnterpriseEmailClient;
import com.github.shuaidd.client.EnterpriseInterConnectionClient;
import com.github.shuaidd.client.ExternalContactClient;
import com.github.shuaidd.client.LinkedCorpClient;
import com.github.shuaidd.client.MeetingClient;
import com.github.shuaidd.client.MessageClient;
import com.github.shuaidd.client.ServiceProviderClient;
import com.github.shuaidd.client.WeChatCallCenterClient;
import com.github.shuaidd.client.WeChatClient;
import com.github.shuaidd.client.WeChatMediaClient;
import com.github.shuaidd.client.WorkApplicationClient;
import com.github.shuaidd.client.WorkOaClient;
import com.github.shuaidd.client.config.ApplicationProperties;
import com.github.shuaidd.client.config.WeChatConfigurationProperties;
import com.github.shuaidd.exception.ParamCheckException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractBaseService {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected WeChatClient weChatClient;
    @Autowired
    protected ExternalContactClient externalContactClient;
    @Autowired
    protected WorkOaClient workOaClient;
    @Autowired
    protected WeChatCallCenterClient callCenterClient;
    @Autowired
    protected AddressBookClient addressBookClient;
    @Autowired
    protected WeChatMediaClient weChatMediaClient;
    @Autowired
    protected WorkApplicationClient applicationClient;
    @Autowired
    protected MessageClient messageClient;
    @Autowired
    protected EfficiencyToolClient efficiencyToolClient;
    @Autowired
    protected LinkedCorpClient linkedCorpClient;
    @Autowired
    protected ServiceProviderClient serviceProviderClient;
    @Autowired
    protected AuthClient authClient;
    @Autowired
    protected EnterpriseEmailClient emailClient;
    @Autowired
    protected ElectronicInvoiceClient electronicInvoiceClient;
    @Autowired
    protected EnterpriseInterConnectionClient enterpriseInterConnectionClient;
    @Autowired
    protected WeChatConfigurationProperties properties;
    @Autowired
    protected MeetingClient meetingClient;

    String getApplicationSecret(String applicationName) {
        String secret = "";
        List<ApplicationProperties> list = this.properties.getApplicationList();
        if (CollectionUtils.isNotEmpty(list)) {
            for (ApplicationProperties applicationProperties : list) {
                if (!Objects.equals(applicationName, applicationProperties.getApplicationName())) continue;
                secret = applicationProperties.getSecret();
            }
        }
        if (StringUtils.isEmpty((CharSequence)secret)) {
            throw new ParamCheckException(applicationName + "\u5e94\u7528\u4e0d\u5b58\u5728\u5bc6\u5319");
        }
        return secret;
    }

    ApplicationProperties getApp(String applicationName) {
        List<ApplicationProperties> list = this.properties.getApplicationList();
        if (CollectionUtils.isNotEmpty(list)) {
            for (ApplicationProperties applicationProperties : list) {
                if (!Objects.equals(applicationName, applicationProperties.getApplicationName())) continue;
                return applicationProperties;
            }
        }
        return null;
    }

    public void checkApplication(String appName) {
        if (StringUtils.isEmpty((CharSequence)appName)) {
            throw new ParamCheckException("\u8c03\u7528\u63a5\u53e3\u7684\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean exist = false;
        for (ApplicationProperties applicationProperties : this.properties.getApplicationList()) {
            if (!appName.equals(applicationProperties.getApplicationName())) continue;
            exist = true;
            break;
        }
        List validAppNames = this.properties.getApplicationList().stream().map(ApplicationProperties::getApplicationName).collect(Collectors.toList());
        if (!exist) {
            throw new ParamCheckException("\u5e94\u7528\u540d\u79f0\u3010" + appName + "\u3011\u65e0\u6548\uff0c\u4e0d\u5728\u6709\u6548\u914d\u7f6e\u5217\u8868\u4e4b\u5185-->" + validAppNames);
        }
    }
}

