/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.service;

import com.github.shuaidd.dto.addressbook.Department;
import com.github.shuaidd.dto.addressbook.DeptUser;
import com.github.shuaidd.dto.addressbook.Tag;
import com.github.shuaidd.dto.addressbook.WeChatUser;
import com.github.shuaidd.dto.tool.CallbackData;
import com.github.shuaidd.response.BaseResponse;
import com.github.shuaidd.response.addressbook.ActiveStatResponse;
import com.github.shuaidd.response.addressbook.AsyncJobResponse;
import com.github.shuaidd.response.addressbook.AsyncJobResultResponse;
import com.github.shuaidd.response.addressbook.ConvertUserIdOpenIdResponse;
import com.github.shuaidd.response.addressbook.CreateDepartmentResponse;
import com.github.shuaidd.response.addressbook.CreateTagResponse;
import com.github.shuaidd.response.addressbook.DepartmentListResponse;
import com.github.shuaidd.response.addressbook.DepartmentUserResponse;
import com.github.shuaidd.response.addressbook.ExportResultResponse;
import com.github.shuaidd.response.addressbook.JoinQrCodeResponse;
import com.github.shuaidd.response.addressbook.QueryTagUserResponse;
import com.github.shuaidd.response.addressbook.SimpleDepartmentListResponse;
import com.github.shuaidd.response.addressbook.SimpleDeptUserResponse;
import com.github.shuaidd.response.addressbook.TagListResponse;
import com.github.shuaidd.response.addressbook.TagUserResponse;
import com.github.shuaidd.response.addressbook.WeChatUserResponse;
import com.github.shuaidd.response.linkedcorp.LinkedCorpDeptResponse;
import com.github.shuaidd.response.linkedcorp.LinkedCorpDeptUserListResponse;
import com.github.shuaidd.response.linkedcorp.LinkedCorpDeptUserResponse;
import com.github.shuaidd.response.linkedcorp.LinkedCorpUserResponse;
import com.github.shuaidd.response.linkedcorp.PermListResponse;
import com.github.shuaidd.resquest.CursorPageRequest;
import com.github.shuaidd.resquest.addressbook.ActiveStatRequest;
import com.github.shuaidd.resquest.addressbook.AddressBookExportRequest;
import com.github.shuaidd.resquest.addressbook.AsyncJobRequest;
import com.github.shuaidd.resquest.addressbook.BatchDeleteUserRequest;
import com.github.shuaidd.resquest.addressbook.ConvertUserIdOpenIdRequest;
import com.github.shuaidd.resquest.addressbook.CreateUserRequest;
import com.github.shuaidd.resquest.addressbook.DepartmentRequest;
import com.github.shuaidd.resquest.addressbook.InviteUserRequest;
import com.github.shuaidd.resquest.addressbook.TagRequest;
import com.github.shuaidd.resquest.addressbook.TagUserRequest;
import com.github.shuaidd.resquest.addressbook.UpdateUserRequest;
import com.github.shuaidd.resquest.linkedcorp.LinkedCorpDeptRequest;
import com.github.shuaidd.resquest.linkedcorp.LinkedCropUserRequest;
import com.github.shuaidd.service.AbstractBaseService;
import com.github.shuaidd.service.MediaService;
import java.io.OutputStream;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
public class AddressBookService
extends AbstractBaseService {
    private static final String ASYNC_BATCH_UPDATE_USER_FILE = "asyncBatchUpdateUser-%s.csv";
    private static final String FULL_COVER_USER_FILE = "fullCoverUser-%s.csv";
    private static final String ASYNC_BATCH_UPDATE_USER = "asyncBatchUpdateUser";
    private static final String FULL_COVER_USER = "fullCoverUser";
    private static final String ASYNC_BATCH_UPDATE_USER_FILE_TITLE = "\u59d3\u540d,\u5e10\u53f7,\u624b\u673a\u53f7,\u90ae\u7bb1,\u6240\u5728\u90e8\u95e8,\u804c\u4f4d,\u6027\u522b,\u662f\u5426\u90e8\u95e8\u5185\u9886\u5bfc,\u6392\u5e8f,\u522b\u540d,\u5730\u5740,\u5ea7\u673a,\u7981\u7528,\u7981\u7528\u9879\u8bf4\u660e\uff1a(0-\u542f\u7528;1-\u7981\u7528)\n";
    private static final String FULL_COVER_DEPARTMENT_FILE_TITLE = "\u90e8\u95e8\u540d\u79f0,\u90e8\u95e8ID,\u7236\u90e8\u95e8ID,\u6392\u5e8f\n";
    private static final String FULL_COVER_DEPARTMENT_FILE = "fullCoverUser-%s.csv";
    private final MediaService mediaService;

    @Autowired
    public AddressBookService(MediaService mediaService) {
        this.mediaService = mediaService;
    }

    public void createUser(CreateUserRequest request, String applicationName) {
        if (Objects.nonNull(request)) {
            this.addressBookClient.createUser(request, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u7528\u6237\u521b\u5efa\u6210\u529f:{}", (Object)request);
            }
        }
    }

    public WeChatUserResponse getUser(String userId, String applicationName) {
        WeChatUserResponse weChatUserResponse = null;
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            weChatUserResponse = this.addressBookClient.getUser(userId, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u8bfb\u53d6\u5230\u6210\u5458\u4fe1\u606f\uff1a{}", (Object)weChatUserResponse);
            }
        }
        return weChatUserResponse;
    }

    public void updateUser(UpdateUserRequest request, String applicationName) {
        if (Objects.nonNull(request) && StringUtils.isNotEmpty((CharSequence)request.getUserId())) {
            this.addressBookClient.updateUser(request, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u66f4\u65b0\u6210\u5458\u4fe1\u606f\u6210\u529f\uff1auserId-{},applicationName-{}", (Object)request.getUserId(), (Object)applicationName);
            }
        }
    }

    public void deleteUser(String userId, String applicationName) {
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            this.addressBookClient.deleteUser(userId, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u5220\u9664\u6210\u5458\u6210\u529f\uff1auserId-{},applicationName-{}", (Object)userId, (Object)applicationName);
            }
        }
    }

    public void batchDeleteUser(BatchDeleteUserRequest request, String applicationName) {
        if (Objects.nonNull(request) && CollectionUtils.isNotEmpty((Collection)request.getUserIdList())) {
            this.addressBookClient.batchDelete(request, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u6279\u91cf\u5220\u9664\u6210\u5458\u6210\u529f\uff1a{},applicationName-{}", (Object)request, (Object)applicationName);
            }
        }
    }

    public List<WeChatUser> getDepartmentUser(Integer departmentId, boolean fetchChild, String applicationName) {
        List<Object> weChatUsers = new ArrayList<WeChatUser>(1);
        if (Objects.nonNull(departmentId)) {
            Integer getChild = fetchChild ? 1 : 0;
            DepartmentUserResponse departmentUserResponse = this.addressBookClient.getDepartmentUser(departmentId, getChild, applicationName);
            weChatUsers = departmentUserResponse.getWeChatUserList();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u83b7\u53d6\u90e8\u95e8\u6210\u5458\u6210\u529f\uff1aapplicationName-{}--weChatUsers--{}", (Object)applicationName, weChatUsers);
            }
        }
        return weChatUsers;
    }

    public List<WeChatUser> getDepartmentUserDetail(Integer departmentId, boolean fetchChild, String applicationName) {
        List<Object> weChatUsers = new ArrayList<WeChatUser>(1);
        if (Objects.nonNull(departmentId)) {
            Integer getChild = fetchChild ? 1 : 0;
            DepartmentUserResponse departmentUserResponse = this.addressBookClient.getDepartmentUserDetail(departmentId, getChild, applicationName);
            weChatUsers = departmentUserResponse.getWeChatUserList();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u83b7\u53d6\u90e8\u95e8\u6210\u5458\u8be6\u60c5\u6210\u529f\uff1aapplicationName-{}--weChatUsers--{}", (Object)applicationName, weChatUsers);
            }
        }
        return weChatUsers;
    }

    public String convertToOpenId(String userId, String applicationName) {
        String openId = null;
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            ConvertUserIdOpenIdResponse response = this.addressBookClient.convertToOpenId(new ConvertUserIdOpenIdRequest(userId, null), applicationName);
            openId = response.getOpenId();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u83b7\u53d6openId\u6210\u529f\uff1aopenid-{}----applicationName-{}", (Object)openId, (Object)applicationName);
            }
        }
        return openId;
    }

    public String convertToUserId(String openId, String applicationName) {
        String userId = null;
        if (StringUtils.isNotEmpty((CharSequence)openId)) {
            ConvertUserIdOpenIdResponse response = this.addressBookClient.convertToUserId(new ConvertUserIdOpenIdRequest(null, openId), applicationName);
            userId = response.getUserId();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u83b7\u53d6\u7528\u6237ID\u6210\u529f\uff1auserId-{}, applicationName-{}", (Object)userId, (Object)applicationName);
            }
        }
        return userId;
    }

    public void authSuccess(String userId, String applicationName) {
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            BaseResponse response = this.addressBookClient.authSucc(userId, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u4e8c\u6b21\u9a8c\u8bc1\u6210\u529f\uff1auserId-{},applicationName-{}", (Object)userId, (Object)applicationName);
            }
        }
    }

    public void invite(InviteUserRequest request, String applicationName) {
        if (Objects.nonNull(request)) {
            if (CollectionUtils.isEmpty((Collection)request.getParty()) && CollectionUtils.isEmpty((Collection)request.getTag()) && CollectionUtils.isEmpty((Collection)request.getUser())) {
                return;
            }
            BaseResponse baseResponse = this.addressBookClient.invite(request, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u9080\u8bf7\u6210\u529f\uff1aapplicationName-{}", (Object)applicationName);
            }
        }
    }

    public CreateDepartmentResponse createDepartment(DepartmentRequest request, String applicationName) {
        CreateDepartmentResponse response = null;
        if (Objects.nonNull(request) && StringUtils.isNotEmpty((CharSequence)request.getName())) {
            response = this.addressBookClient.createDepartment(request, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u521b\u5efa\u90e8\u95e8\u6210\u529f\uff1a\u90e8\u95e8\u7f16\u53f7-{},applicationName-{}", (Object)response.getId(), (Object)applicationName);
            }
        }
        return response;
    }

    public void updateDepartment(DepartmentRequest request, String applicationName) {
        if (Objects.nonNull(request) && Objects.nonNull(request.getId())) {
            this.addressBookClient.updateDepartment(request, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u66f4\u65b0\u90e8\u95e8\u6210\u529f\uff1a\u66f4\u65b0\u4fe1\u606f-{},applicationName-{}", (Object)request, (Object)applicationName);
            }
        }
    }

    public void deleteDepartment(Integer id, String applicationName) {
        if (Objects.nonNull(id)) {
            this.addressBookClient.deleteDepartment(id, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u5220\u9664\u90e8\u95e8\u6210\u529f\uff1a\u90e8\u95e8\u7f16\u53f7-{},applicationName-{}", (Object)id, (Object)applicationName);
            }
        }
    }

    public List<Department> departmentList(Integer id, String applicationName) {
        DepartmentListResponse response = this.addressBookClient.departmentList(id, applicationName);
        List departments = response.getDepartments();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\u62c9\u53d6\u90e8\u95e8\u5217\u8868\u6210\u529f\uff1a\u90e8\u95e8\u6570\u91cf-{},applicationName-{}\uff0cdepartments--{}", new Object[]{departments.size(), applicationName, departments});
        }
        return departments;
    }

    public List<Department> simpleDepartmentList(Integer id, String applicationName) {
        SimpleDepartmentListResponse response = this.addressBookClient.departmentSimpleList(id, applicationName);
        List departments = response.getDepartments();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\u62c9\u53d6\u90e8\u95e8\u5217\u8868\u6210\u529f\uff1a\u90e8\u95e8\u6570\u91cf-{},applicationName-{}\uff0cdepartments--{}", new Object[]{departments.size(), applicationName, departments});
        }
        return departments;
    }

    public Integer createTag(TagRequest request, String applicationName) {
        Integer tagId = null;
        if (Objects.nonNull(request) && StringUtils.isNotEmpty((CharSequence)request.getTagName())) {
            CreateTagResponse createTagResponse = this.addressBookClient.createTag(request, applicationName);
            tagId = createTagResponse.getTagId();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u521b\u5efa\u6807\u7b7e\u6210\u529f\uff1a\u6807\u7b7e\u7f16\u53f7-{},applicationName-{}", (Object)tagId, (Object)applicationName);
            }
        }
        return tagId;
    }

    public void updateTagName(Integer tagId, String tagName, String applicationName) {
        if (Objects.nonNull(tagId) && StringUtils.isNotEmpty((CharSequence)tagName)) {
            TagRequest tagRequest = new TagRequest();
            tagRequest.setTagId(tagId);
            tagRequest.setTagName(tagName);
            this.addressBookClient.updateTag(tagRequest, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u66f4\u65b0\u6807\u7b7e\u540d\u5b57\u6210\u529f\uff1a\u6807\u7b7e\u7f16\u53f7[{}],\u6807\u7b7e\u540d\u79f0[{}],applicationName-{}", new Object[]{tagId, tagName, applicationName});
            }
        }
    }

    public void deleteTag(Integer tagId, String applicationName) {
        if (Objects.nonNull(tagId)) {
            this.addressBookClient.deleteTag(tagId, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u5220\u9664\u6807\u7b7e\u6210\u529f\uff1a\u6807\u7b7e\u7f16\u53f7[{}],applicationName-{}", (Object)tagId, (Object)applicationName);
            }
        }
    }

    public QueryTagUserResponse getTagUser(Integer tagId, String applicationName) {
        QueryTagUserResponse response = null;
        if (Objects.nonNull(tagId)) {
            response = this.addressBookClient.getTagUser(tagId, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u83b7\u53d6\u6807\u7b7e\u6210\u5458\u6210\u529f\uff1a\u6807\u7b7e\u7f16\u53f7[{}],applicationName-{}--\u6210\u5458--{}", new Object[]{tagId, applicationName, response.getUserList()});
            }
        }
        return response;
    }

    public TagUserResponse addTagUsers(TagUserRequest request, String applicationName) {
        TagUserResponse response = null;
        if (Objects.nonNull(request) && Objects.nonNull(request.getTagId())) {
            response = this.addressBookClient.addTagUsers(request, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u589e\u52a0\u6807\u7b7e\u6210\u5458\u6210\u529f\uff1a\u6807\u7b7e\u7f16\u53f7[{}],applicationName-{}", (Object)request.getTagId(), (Object)applicationName);
            }
        }
        return response;
    }

    public TagUserResponse deleteTagUsers(TagUserRequest request, String applicationName) {
        TagUserResponse response = null;
        if (Objects.nonNull(request) && Objects.nonNull(request.getTagId())) {
            response = this.addressBookClient.deleteTagUsers(request, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u5220\u9664\u6807\u7b7e\u6210\u5458\u6210\u529f\uff1a\u6807\u7b7e\u7f16\u53f7[{}],applicationName-{}", (Object)request.getTagId(), (Object)applicationName);
            }
        }
        return response;
    }

    public List<Tag> getTagList(String applicationName) {
        TagListResponse response = this.addressBookClient.getTagList(applicationName);
        List tags = response.getTagList();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\u83b7\u53d6\u6807\u7b7e\u5217\u8868\u6210\u529f\uff1aapplicationName-{}--tags--{}", (Object)applicationName, (Object)tags);
        }
        return tags;
    }

    public String asyncBatchUpdateUser(List<WeChatUser> weChatUsers, Boolean toInvite, CallbackData callbackData, String applicationName) {
        return this.asyncHandleUser(weChatUsers, toInvite, callbackData, applicationName, ASYNC_BATCH_UPDATE_USER);
    }

    public String asyncBatchUpdateUser(List<WeChatUser> weChatUsers, Boolean toInvite, String applicationName) {
        return this.asyncBatchUpdateUser(weChatUsers, toInvite, null, applicationName);
    }

    public String fullCoverUser(List<WeChatUser> weChatUsers, Boolean toInvite, CallbackData callbackData, String applicationName) {
        return this.asyncHandleUser(weChatUsers, toInvite, callbackData, applicationName, FULL_COVER_USER);
    }

    public String fullCoverUser(List<WeChatUser> weChatUsers, Boolean toInvite, String applicationName) {
        return this.asyncHandleUser(weChatUsers, toInvite, null, applicationName, FULL_COVER_USER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String asyncHandleUser(List<WeChatUser> weChatUsers, Boolean toInvite, CallbackData callbackData, String applicationName, String type) {
        String fileName = "";
        if (ASYNC_BATCH_UPDATE_USER.equals(type)) {
            fileName = ASYNC_BATCH_UPDATE_USER_FILE;
        } else if (FULL_COVER_USER.equals(type)) {
            fileName = "fullCoverUser-%s.csv";
        }
        DiskFileItem fileItem = (DiskFileItem)new DiskFileItemFactory().createItem("file", MediaType.TEXT_PLAIN.getType(), true, String.format(fileName, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddhhmmss")));
        try (OutputStream os = fileItem.getOutputStream();){
            if (CollectionUtils.isNotEmpty(weChatUsers)) {
                IOUtils.write((String)ASYNC_BATCH_UPDATE_USER_FILE_TITLE, (OutputStream)os);
                for (WeChatUser weChatUser : weChatUsers) {
                    String line = this.buildUserLine(weChatUser);
                    IOUtils.write((String)line, (OutputStream)os);
                }
            }
            CommonsMultipartFile multi = new CommonsMultipartFile((FileItem)fileItem);
            String mediaId = this.mediaService.uploadMaterial((MultipartFile)multi, "file", applicationName);
            AsyncJobRequest request = this.buildAsyncJobRequest(mediaId, toInvite, callbackData);
            AsyncJobResponse response = null;
            if (ASYNC_BATCH_UPDATE_USER.equals(type)) {
                response = this.addressBookClient.asyncBatchUpdateUser(request, applicationName);
            } else if (FULL_COVER_USER.equals(type)) {
                response = this.addressBookClient.fullCoverUser(request, applicationName);
            }
            String string = Objects.nonNull(response) ? response.getJobId() : "";
            return string;
        }
        catch (Exception e) {
            this.logger.error("\u5f02\u6b65\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u5f02\u5e38:{}\uff0ctype: {}", new Object[]{applicationName, type, e});
            return null;
        }
    }

    private String buildUserLine(WeChatUser weChatUser) {
        if (Objects.nonNull(weChatUser)) {
            return StringUtils.defaultString((String)weChatUser.getName(), (String)"") + "," + StringUtils.defaultString((String)weChatUser.getUserId(), (String)"") + "," + StringUtils.defaultString((String)weChatUser.getMobile(), (String)"") + "," + StringUtils.defaultString((String)weChatUser.getEmail(), (String)"") + "," + this.getStringFromList(weChatUser.getDepartment()) + "," + StringUtils.defaultString((String)weChatUser.getPosition(), (String)"") + "," + this.getStringFromList(weChatUser.getIsLeaderInDept()) + "," + this.getStringFromList(weChatUser.getOrder()) + "," + StringUtils.defaultString((String)weChatUser.getAlias(), (String)"") + "," + StringUtils.defaultString((String)weChatUser.getAddress(), (String)"") + "," + StringUtils.defaultString((String)weChatUser.getTelephone(), (String)"") + "," + (weChatUser.getEnable() == null ? "" : String.valueOf(weChatUser.getEnable())) + ",\n";
        }
        return null;
    }

    private AsyncJobRequest buildAsyncJobRequest(String mediaId, Boolean toInvite, CallbackData callbackData) {
        AsyncJobRequest request = new AsyncJobRequest();
        request.setMediaId(mediaId);
        request.setToInvite(toInvite);
        request.setCallback(callbackData);
        return request;
    }

    private String getStringFromList(List<Integer> list) {
        StringBuilder result = new StringBuilder();
        if (CollectionUtils.isNotEmpty(list)) {
            for (Integer data : list) {
                result.append(data).append(";");
            }
            if (result.toString().endsWith(";")) {
                result.deleteCharAt(result.length() - 1);
            }
        }
        return result.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fullCoverDepartment(List<Department> departments, CallbackData callbackData, String applicationName) {
        DiskFileItem fileItem = (DiskFileItem)new DiskFileItemFactory().createItem("file", MediaType.TEXT_PLAIN.getType(), true, String.format("fullCoverUser-%s.csv", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddhhmmss")));
        try (OutputStream os = fileItem.getOutputStream();){
            CommonsMultipartFile multi;
            String mediaId;
            AsyncJobRequest request;
            AsyncJobResponse response;
            if (CollectionUtils.isNotEmpty(departments)) {
                IOUtils.write((String)FULL_COVER_DEPARTMENT_FILE_TITLE, (OutputStream)os);
                for (Department department : departments) {
                    String line = StringUtils.defaultString((String)department.getName(), (String)"") + "," + (department.getId() == null ? "" : String.valueOf(department.getId())) + "," + (department.getParentId() == null ? "" : String.valueOf(department.getParentId())) + "," + (department.getOrder() == null ? "" : String.valueOf(department.getOrder())) + "\n";
                    IOUtils.write((String)line, (OutputStream)os);
                }
            }
            String string = Objects.nonNull(response = this.addressBookClient.fullCoverDepartment(request = this.buildAsyncJobRequest(mediaId = this.mediaService.uploadMaterial((MultipartFile)(multi = new CommonsMultipartFile((FileItem)fileItem)), "file", applicationName), null, callbackData), applicationName)) ? response.getJobId() : "";
            return string;
        }
        catch (Exception e) {
            this.logger.error("\u5168\u91cf\u8986\u76d6\u90e8\u95e8\u5f02\u5e38:{}", (Object)applicationName, (Object)e);
            return null;
        }
    }

    public String fullCoverDepartment(List<Department> departments, String applicationName) {
        return this.fullCoverDepartment(departments, null, applicationName);
    }

    public AsyncJobResultResponse jobResult(String jobId, String applicationName) {
        AsyncJobResultResponse resultResponse = null;
        if (StringUtils.isNotEmpty((CharSequence)jobId)) {
            resultResponse = this.addressBookClient.jobResult(jobId, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u83b7\u53d6\u4efb\u52a1\u6267\u884c\u7ed3\u679c\u6210\u529f\uff1a{}", (Object)resultResponse);
            }
        }
        return resultResponse;
    }

    public String getCorpQrCode(Integer sizeType, String applicationName) {
        JoinQrCodeResponse response = this.addressBookClient.getJoinQrCode(sizeType, applicationName);
        return response.getJoinQrCode();
    }

    public Integer getActiveStat(Date date, String applicationName) {
        if (date == null) {
            return 0;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String formatDate = format.format(date);
        ActiveStatRequest request = new ActiveStatRequest();
        request.setDate(formatDate);
        ActiveStatResponse response = this.addressBookClient.getActiveStat(request, applicationName);
        return response.getActiveCnt();
    }

    public String exportUser(AddressBookExportRequest request, String applicationName) {
        AsyncJobResponse response = this.addressBookClient.exportUser(request, applicationName);
        return response.getJobId();
    }

    public String exportUserDetail(AddressBookExportRequest request, String applicationName) {
        AsyncJobResponse response = this.addressBookClient.exportUserDetail(request, applicationName);
        return response.getJobId();
    }

    public String exportDepartment(AddressBookExportRequest request, String applicationName) {
        AsyncJobResponse response = this.addressBookClient.exportDepartment(request, applicationName);
        return response.getJobId();
    }

    public String exportTagUser(AddressBookExportRequest request, String applicationName) {
        AsyncJobResponse response = this.addressBookClient.exportTagUser(request, applicationName);
        return response.getJobId();
    }

    public ExportResultResponse getExportResult(String jobId, String applicationName) {
        return this.weChatClient.getExportResult(jobId, applicationName);
    }

    public String getDecryptExportData(String aesKey, String url) {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.getForEntity(url, byte[].class, new Object[0]);
        if (responseEntity.getBody() == null) {
            return null;
        }
        byte[] key = Base64.decodeBase64((String)(aesKey + "="));
        byte[] original = null;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(key, 0, 16));
            cipher.init(2, (Key)keySpec, iv);
            original = cipher.doFinal((byte[])responseEntity.getBody());
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
        assert (original != null);
        this.logger.info("\u6570\u636e\u89e3\u5bc6--{}", (Object)new String(original));
        return new String(original);
    }

    public List<DeptUser> getUserIds(CursorPageRequest request, String applicationName) {
        SimpleDeptUserResponse response = this.addressBookClient.getUserIds(request, applicationName);
        return response.getDeptUsers();
    }

    public PermListResponse getPermList(String applicationName) {
        return this.linkedCorpClient.getPermList(applicationName);
    }

    public LinkedCorpUserResponse getUserDetail(LinkedCropUserRequest request, String applicationName) {
        return this.linkedCorpClient.getUserDetail(request, applicationName);
    }

    public LinkedCorpDeptUserResponse getDeptUser(LinkedCorpDeptRequest request, String applicationName) {
        return this.linkedCorpClient.getDeptUser(request, applicationName);
    }

    public LinkedCorpDeptUserListResponse getDeptUserList(LinkedCorpDeptRequest request, String applicationName) {
        return this.linkedCorpClient.getDeptUserList(request, applicationName);
    }

    public LinkedCorpDeptResponse getDeptList(LinkedCorpDeptRequest request, String applicationName) {
        return this.linkedCorpClient.getDeptList(request, applicationName);
    }
}

