/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.service;

import com.github.shuaidd.exception.ParamCheckException;
import com.github.shuaidd.response.application.ApplicationButtonResponse;
import com.github.shuaidd.response.application.WeChatApplicationResponse;
import com.github.shuaidd.resquest.application.ApplicationButtonRequest;
import com.github.shuaidd.service.AbstractBaseService;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ApplicationService
extends AbstractBaseService {
    public WeChatApplicationResponse getApplication(String agentId, String applicationName) {
        if (StringUtils.isNotEmpty((CharSequence)agentId)) {
            return this.applicationClient.getApplication(agentId, applicationName);
        }
        throw new ParamCheckException("agentId \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01\uff01\uff01");
    }

    public void createApplicationButton(ApplicationButtonRequest request, String agentId, String applicationName) {
        if (Objects.nonNull(request) && CollectionUtils.isNotEmpty((Collection)request.getButtonList())) {
            this.applicationClient.createApplicationButton(request, agentId, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u5e94\u7528\u83dc\u5355\u521b\u5efa\u6210\u529f:{},{}", (Object)agentId, (Object)applicationName);
            }
        }
    }

    public ApplicationButtonResponse getApplicationButtons(String agentId, String applicationName) {
        ApplicationButtonResponse response = null;
        if (StringUtils.isNotEmpty((CharSequence)agentId)) {
            response = this.applicationClient.getApplicationButtons(agentId, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u5e94\u7528\u83dc\u5355\u83b7\u53d6\u6210\u529f:{},{}", (Object)agentId, (Object)applicationName);
            }
        }
        return response;
    }

    public void deleteApplicationButtons(String agentId, String applicationName) {
        if (StringUtils.isNotEmpty((CharSequence)agentId)) {
            this.applicationClient.deleteApplicationButtons(agentId, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u5e94\u7528\u83dc\u5355\u5220\u9664\u6210\u529f:{},{}", (Object)agentId, (Object)applicationName);
            }
        } else {
            throw new ParamCheckException("agentId \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01\uff01\uff01");
        }
    }
}

