/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.service;

import com.github.shuaidd.exception.ParamCheckException;
import com.github.shuaidd.response.auth.AuthUserInfoResponse;
import com.github.shuaidd.response.auth.AuthenticationResponse;
import com.github.shuaidd.response.auth.UserSensitiveDetailResponse;
import com.github.shuaidd.response.tool.ApiDomainIpResponse;
import com.github.shuaidd.response.tool.OpenUserId2UserIdResponse;
import com.github.shuaidd.response.tool.TransformExternalUserIdResponse;
import com.github.shuaidd.resquest.auth.UserSensitiveRequest;
import com.github.shuaidd.resquest.tool.OpenUserId2UserIdRequest;
import com.github.shuaidd.resquest.tool.TransformExternalUserIdRequest;
import com.github.shuaidd.service.AbstractBaseService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationService
extends AbstractBaseService {
    public AuthenticationResponse getAuthentication(String code, String applicationName) {
        AuthenticationResponse response;
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            response = this.addressBookClient.getAuthentication(code, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u5e94\u7528: {},\u6839\u636ecode:{},\u83b7\u53d6\u5230\u7528\u6237\u8eab\u4efd\uff1a{}", new Object[]{applicationName, code, response});
            }
        } else {
            throw new ParamCheckException("code \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01\uff01\uff01");
        }
        return response;
    }

    public List<String> apiDomainIp(String applicationName) {
        ApiDomainIpResponse apiDomainIpResponse = this.weChatClient.apiDomainIp(applicationName);
        return apiDomainIpResponse.getIpList();
    }

    public List<String> callBackIp(String applicationName) {
        ApiDomainIpResponse apiDomainIpResponse = this.weChatClient.callBackIp(applicationName);
        return apiDomainIpResponse.getIpList();
    }

    public OpenUserId2UserIdResponse openUserId2UserId(OpenUserId2UserIdRequest request, String applicationName) {
        return this.weChatClient.openUserId2UserId(request, applicationName);
    }

    public TransformExternalUserIdResponse transformExternalUserId(TransformExternalUserIdRequest request, String applicationName) {
        return this.weChatClient.transformExternalUserId(request, applicationName);
    }

    public AuthUserInfoResponse getUserInfo(String code, String applicationName) {
        return this.authClient.getUserInfo(code, applicationName);
    }

    public UserSensitiveDetailResponse getUserDetail(String userTicket, String applicationName) {
        UserSensitiveRequest request = new UserSensitiveRequest();
        request.setUserTicket(userTicket);
        return this.authClient.getUserDetail(request, applicationName);
    }
}

