/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.service;

import com.github.shuaidd.response.addressbook.AsyncJobResponse;
import com.github.shuaidd.response.material.UploadByUrlResultResponse;
import com.github.shuaidd.response.material.UploadImageResponse;
import com.github.shuaidd.response.material.WeChatMediaUploadResponse;
import com.github.shuaidd.resquest.job.JobIdRequest;
import com.github.shuaidd.resquest.media.UploadByUrlRequest;
import com.github.shuaidd.service.AbstractBaseService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
public class MediaService
extends AbstractBaseService {
    public static final String FILE = "file";
    public static final String IMAGE = "image";
    public static final String VOICE = "voice";
    public static final String VIDEO = "video";

    public String uploadMaterial(File file, MediaType mediaType, String type, String applicationName) {
        String mediaId = null;
        if (Objects.nonNull(file) && Objects.nonNull(mediaType)) {
            DiskFileItem fileItem = this.diskFileItem(file, mediaType, applicationName);
            CommonsMultipartFile multi = new CommonsMultipartFile((FileItem)fileItem);
            mediaId = this.uploadMaterial((MultipartFile)multi, type, applicationName);
        }
        return mediaId;
    }

    public String uploadMaterial(MultipartFile file, String type, String applicationName) {
        if (Objects.nonNull(file) && Objects.nonNull(type)) {
            WeChatMediaUploadResponse response = this.weChatMediaClient.uploadMaterial(file, type, applicationName);
            return response.getMediaId();
        }
        return null;
    }

    public String uploadAttachment(MultipartFile file, String mediaType, Integer attachmentType, String applicationName) {
        if (Objects.nonNull(file) && Objects.nonNull(mediaType) && Objects.nonNull(attachmentType)) {
            WeChatMediaUploadResponse response = this.weChatMediaClient.uploadAttachment(file, mediaType, attachmentType, applicationName);
            return response.getMediaId();
        }
        return null;
    }

    public String uploadAttachment(File file, String mediaType, Integer attachmentType, String applicationName) {
        if (Objects.nonNull(file) && Objects.nonNull(mediaType) && Objects.nonNull(attachmentType)) {
            DiskFileItem fileItem = this.diskFileItem(file, MediaType.parseMediaType((String)"application/octet-stream"), applicationName);
            CommonsMultipartFile multi = new CommonsMultipartFile((FileItem)fileItem);
            return this.uploadAttachment((MultipartFile)multi, mediaType, attachmentType, applicationName);
        }
        return null;
    }

    public String uploadImage(File file, MediaType mediaType, String applicationName) {
        if (Objects.nonNull(file) && Objects.nonNull(mediaType)) {
            DiskFileItem fileItem = this.diskFileItem(file, mediaType, applicationName);
            CommonsMultipartFile multi = new CommonsMultipartFile((FileItem)fileItem);
            UploadImageResponse response = this.weChatMediaClient.uploadImage((MultipartFile)multi, applicationName);
            return response.getUrl();
        }
        return null;
    }

    private DiskFileItem diskFileItem(File file, MediaType mediaType, String applicationName) {
        DiskFileItem fileItem = (DiskFileItem)new DiskFileItemFactory().createItem(FILE, mediaType.getType(), true, file.getName());
        try (FileInputStream input = new FileInputStream(file);
             OutputStream os = fileItem.getOutputStream();){
            IOUtils.copy((InputStream)input, (OutputStream)os);
        }
        catch (Exception e) {
            this.logger.error("\u62f7\u8d1d\u7d20\u6750\u5f02\u5e38:{}", (Object)applicationName, (Object)e);
            throw new IllegalArgumentException("Invalid file: " + e, e);
        }
        return fileItem;
    }

    public ResponseEntity<byte[]> download(String mediaId, String applicationName) {
        ResponseEntity<byte[]> responseEntity = null;
        if (StringUtils.isNotEmpty((CharSequence)mediaId)) {
            responseEntity = this.weChatMediaClient.download(mediaId, applicationName);
        }
        return responseEntity;
    }

    public ResponseEntity<byte[]> downloadJsMedia(String mediaId, String applicationName) {
        return this.weChatMediaClient.downloadJsMedia(mediaId, applicationName);
    }

    public File downloadJsMediaFile(String mediaId, String downloadFilePath, String applicationName) {
        return this.weChatMediaClient.downloadJsMediaFile(mediaId, downloadFilePath, applicationName);
    }

    public File downloadFile(String mediaId, String downloadFilePath, String applicationName) {
        return this.weChatMediaClient.downloadFile(mediaId, downloadFilePath, applicationName);
    }

    public String uploadByUrl(UploadByUrlRequest request, String applicationName) {
        AsyncJobResponse response = this.weChatClient.uploadByUrl(request, applicationName);
        return response.getJobId();
    }

    public UploadByUrlResultResponse getUploadByUrlResult(JobIdRequest request, String applicationName) {
        return this.weChatClient.getUploadByUrlResult(request, applicationName);
    }
}

