/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.service;

import com.github.shuaidd.dto.message.ChatInfo;
import com.github.shuaidd.exception.ParamCheckException;
import com.github.shuaidd.response.message.CreateAppChatResponse;
import com.github.shuaidd.response.message.SearchAppChatResponse;
import com.github.shuaidd.response.message.SendMessageResponse;
import com.github.shuaidd.resquest.message.CreateAppChatRequest;
import com.github.shuaidd.resquest.message.SendAppChatRequest;
import com.github.shuaidd.resquest.message.SendMessageRequest;
import com.github.shuaidd.resquest.message.UpdateAppChatRequest;
import com.github.shuaidd.service.AbstractBaseService;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MessageService
extends AbstractBaseService {
    public SendMessageResponse sendMessage(SendMessageRequest request, String applicationName) {
        if (Objects.nonNull(request)) {
            return this.messageClient.sendMessage(request, applicationName);
        }
        throw new ParamCheckException("\u8bf7\u6c42 \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01\uff01\uff01");
    }

    public void sendAppChatMessage(SendAppChatRequest request, String applicationName) {
        if (Objects.nonNull(request)) {
            this.messageClient.sendAppChatMessage(request, applicationName);
        }
    }

    public String createAppChat(CreateAppChatRequest request, String applicationName) {
        if (Objects.nonNull(request)) {
            CreateAppChatResponse response = this.messageClient.createAppChat(request, applicationName);
            return response.getChatId();
        }
        throw new ParamCheckException("\u8bf7\u6c42 \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01\uff01\uff01");
    }

    public void updateAppChat(UpdateAppChatRequest request, String applicationName) {
        if (Objects.nonNull(request)) {
            this.messageClient.updateAppChat(request, applicationName);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u66f4\u65b0\u7fa4\u804a\u6210\u529f");
            }
        }
    }

    public ChatInfo searchAppChat(String chatId, String applicationName) {
        ChatInfo chatInfo = null;
        if (StringUtils.isNotEmpty((CharSequence)chatId)) {
            SearchAppChatResponse response = this.messageClient.searchAppChat(chatId, applicationName);
            chatInfo = response.getChatInfo();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\u67e5\u8be2\u5230\u7684\u7fa4\u804a\u4fe1\u606f\uff1a{}", (Object)chatInfo);
            }
        }
        return chatInfo;
    }
}

