/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.service;

import com.github.shuaidd.dto.checkin.CheckInData;
import com.github.shuaidd.dto.checkin.CheckInRule;
import com.github.shuaidd.exception.WeChatException;
import com.github.shuaidd.response.oa.AddMeetingRoomResponse;
import com.github.shuaidd.response.oa.ApplyEventResponse;
import com.github.shuaidd.response.oa.ApprovalDataResponse;
import com.github.shuaidd.response.oa.ApprovalDetailResponse;
import com.github.shuaidd.response.oa.ApproveTemplateResponse;
import com.github.shuaidd.response.oa.BookMeetingRoomResponse;
import com.github.shuaidd.response.oa.BookingInfoResponse;
import com.github.shuaidd.response.oa.CheckInDayReportResponse;
import com.github.shuaidd.response.oa.CheckInOptionResponse;
import com.github.shuaidd.response.oa.CheckInScheduleResponse;
import com.github.shuaidd.response.oa.EmergencyCallResponse;
import com.github.shuaidd.response.oa.GetCallStateResponse;
import com.github.shuaidd.response.oa.JournalRecordResponse;
import com.github.shuaidd.response.oa.JournalReportDetailResponse;
import com.github.shuaidd.response.oa.JournalReportStatResponse;
import com.github.shuaidd.response.oa.MeetingRoomListResponse;
import com.github.shuaidd.response.oa.SpNoResponse;
import com.github.shuaidd.response.oa.UserVacationQuotaResponse;
import com.github.shuaidd.response.oa.VacationConfigResponse;
import com.github.shuaidd.resquest.JournalReportStatRequest;
import com.github.shuaidd.resquest.kf.PunchCorrectionRequest;
import com.github.shuaidd.resquest.oa.AddCheckInUserFaceRequest;
import com.github.shuaidd.resquest.oa.ApplyEventRequest;
import com.github.shuaidd.resquest.oa.ApprovalDataRequest;
import com.github.shuaidd.resquest.oa.ApprovalDetailRequest;
import com.github.shuaidd.resquest.oa.BookMeetingRoomRequest;
import com.github.shuaidd.resquest.oa.CancelBookRequest;
import com.github.shuaidd.resquest.oa.CheckInDataRequest;
import com.github.shuaidd.resquest.oa.CheckInRuleRequest;
import com.github.shuaidd.resquest.oa.CommonOaRequest;
import com.github.shuaidd.resquest.oa.EmergencyCallRequest;
import com.github.shuaidd.resquest.oa.GetApprovalNoRequest;
import com.github.shuaidd.resquest.oa.GetBookingInfoRequest;
import com.github.shuaidd.resquest.oa.GetCallStateRequest;
import com.github.shuaidd.resquest.oa.JournalRecordRequest;
import com.github.shuaidd.resquest.oa.JournalReportDetailRequest;
import com.github.shuaidd.resquest.oa.MeetingRoomRequest;
import com.github.shuaidd.resquest.oa.SetCheckInScheduleRequest;
import com.github.shuaidd.resquest.oa.TemplateRequest;
import com.github.shuaidd.resquest.oa.UpdateUserQuotaRequest;
import com.github.shuaidd.resquest.oa.UserIdRequest;
import com.github.shuaidd.service.AbstractBaseService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class OAService
extends AbstractBaseService {
    private static final int LIMIT_USER_COUNT = 100;

    public List<CheckInData> getCheckInData(CheckInDataRequest request, String applicationName) {
        this.checkRequest(request);
        return this.workOaClient.getCheckInData(request, applicationName).getCheckInDataList();
    }

    private void checkRequest(CheckInDataRequest request) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(request.getEndTime());
        Objects.requireNonNull(request.getOpenCheckInDataType());
        Objects.requireNonNull(request.getStartTime());
        Objects.requireNonNull(request.getUserIdList());
        if (CollectionUtils.isNotEmpty((Collection)request.getUserIdList())) {
            if (request.getUserIdList().size() > 100) {
                throw new WeChatException("\u4e00\u6b21\u67e5\u8be2\u4eba\u6570\u4e0d\u80fd\u8d85\u8fc7100\uff0c\u8bf7\u5206\u6279\u83b7\u53d6");
            }
        } else {
            throw new WeChatException("\u67e5\u8be2\u7684\u4eba\u5458\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public List<CheckInRule> getCheckInOption(CheckInRuleRequest request, String applicationName) {
        ArrayList<CheckInRule> checkInRules = new ArrayList<CheckInRule>(1);
        if (Objects.nonNull(request) && Objects.nonNull(request.getDateTime()) && CollectionUtils.isNotEmpty((Collection)request.getUserIdList())) {
            if (request.getUserIdList().size() <= 100) {
                return this.workOaClient.getCheckInOption(request, applicationName).getCheckInRules();
            }
            throw new WeChatException("\u4e00\u6b21\u67e5\u8be2\u4eba\u6570\u4e0d\u80fd\u8d85\u8fc7100\uff0c\u8bf7\u5206\u6279\u83b7\u53d6");
        }
        return checkInRules;
    }

    public ApprovalDataResponse getApprovalData(ApprovalDataRequest request, String applicationName) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(request.getEndTime());
        Objects.requireNonNull(request.getStartTime());
        ApprovalDataResponse response = this.workOaClient.getApprovalData(request, applicationName);
        this.logger.info("\u83b7\u53d6\u5ba1\u6279\u6570\u636e\u6210\u529f\uff1atotal:{},count:{},next:{}", new Object[]{response.getTotal(), response.getCount(), response.getNextSpNum()});
        return response;
    }

    public CheckInOptionResponse getCorpCheckInOption(String applicationName) {
        return this.workOaClient.getCorpCheckInOption(applicationName);
    }

    public CheckInDayReportResponse getCheckInDayData(CommonOaRequest request, String applicationName) {
        return this.workOaClient.getCheckInDayData(request, applicationName);
    }

    public CheckInDayReportResponse getCheckInMonthData(CommonOaRequest request, String applicationName) {
        return this.workOaClient.getCheckInMonthData(request, applicationName);
    }

    public CheckInScheduleResponse getCheckInScheduleList(CommonOaRequest request, String applicationName) {
        return this.workOaClient.getCheckInScheduList(request, applicationName);
    }

    public void setCheckInScheduleList(SetCheckInScheduleRequest request, String applicationName) {
        this.workOaClient.setCheckInScheduleList(request, applicationName);
    }

    public void addCheckInUserFace(AddCheckInUserFaceRequest request, String applicationName) {
        this.workOaClient.addCheckInUserFace(request, applicationName);
    }

    public ApproveTemplateResponse getTemplateDetail(TemplateRequest request, String applicationName) {
        return this.workOaClient.getTemplateDetail(request, applicationName);
    }

    public ApplyEventResponse applyEvent(ApplyEventRequest request, String applicationName) {
        return this.workOaClient.applyEvent(request, applicationName);
    }

    public SpNoResponse getApprovalInfo(GetApprovalNoRequest request, String applicationName) {
        return this.workOaClient.getApprovalInfo(request, applicationName);
    }

    public ApprovalDetailResponse getApprovalDetail(ApprovalDetailRequest request, String applicationName) {
        return this.workOaClient.getApprovalDetail(request, applicationName);
    }

    public VacationConfigResponse getCorpConf(String applicationName) {
        return this.workOaClient.getCorpConf(applicationName);
    }

    public UserVacationQuotaResponse getUserVacationQuota(UserIdRequest request, String applicationName) {
        return this.workOaClient.getUserVacationQuota(request, applicationName);
    }

    public void setOneUserQuota(UpdateUserQuotaRequest request, String applicationName) {
        this.workOaClient.setOneUserQuota(request, applicationName);
    }

    public JournalRecordResponse getJournalRecordList(JournalRecordRequest recordRequest, String applicationName) {
        return this.workOaClient.getJournalRecordList(recordRequest, applicationName);
    }

    public JournalReportDetailResponse getJournalRecordDetail(JournalReportDetailRequest request, String applicationName) {
        return this.workOaClient.getJournalRecordDetail(request, applicationName);
    }

    public JournalReportStatResponse getJournalStatList(JournalReportStatRequest request, String applicationName) {
        return this.workOaClient.getJournalStatList(request, applicationName);
    }

    public AddMeetingRoomResponse addMeetingRoom(MeetingRoomRequest request, String applicationName) {
        return this.workOaClient.addMeetingRoom(request, applicationName);
    }

    public void updateMeetingRoom(MeetingRoomRequest request, String applicationName) {
        this.workOaClient.updateMeetingRoom(request, applicationName);
    }

    public void delMeetingRoom(MeetingRoomRequest request, String applicationName) {
        this.workOaClient.delMeetingRoom(request, applicationName);
    }

    public MeetingRoomListResponse searchMeetingRoom(MeetingRoomRequest request, String applicationName) {
        return this.workOaClient.searchMeetingRoom(request, applicationName);
    }

    public BookingInfoResponse getBookingInfo(GetBookingInfoRequest request, String applicationName) {
        return this.workOaClient.getBookingInfo(request, applicationName);
    }

    public BookMeetingRoomResponse bookMeetingRoom(BookMeetingRoomRequest request, String applicationName) {
        return this.workOaClient.bookMeetingRoom(request, applicationName);
    }

    public void cancelBookMeetingRoom(CancelBookRequest request, String applicationName) {
        this.workOaClient.cancelBookMeetingRoom(request, applicationName);
    }

    public EmergencyCallResponse pstnccCall(EmergencyCallRequest request, String applicationName) {
        return this.workOaClient.pstnccCall(request, applicationName);
    }

    public GetCallStateResponse pstnccCallState(GetCallStateRequest request, String applicationName) {
        return this.workOaClient.pstnccCallState(request, applicationName);
    }

    public void punchCorrection(PunchCorrectionRequest request, String applicationName) {
        this.workOaClient.punchCorrection(request, applicationName);
    }
}

