/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.service;

import com.github.shuaidd.client.config.ApplicationProperties;
import com.github.shuaidd.exception.ParamCheckException;
import com.github.shuaidd.response.tool.AccessTokenResponse;
import com.github.shuaidd.service.AbstractBaseService;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class TokenService
extends AbstractBaseService {
    @Cacheable(value={"qywx"}, key="'qywx_access_token_'+#applicationName")
    public String getAccessToken(String applicationName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\u8c03\u7528\u63a5\u53e3\u83b7\u53d6AccessToken\uff1a\u5e94\u7528\u540d\u79f0-{}", (Object)applicationName);
        }
        ApplicationProperties app = this.getApp(applicationName);
        if (Objects.isNull(this.properties)) {
            this.logger.error("{} \u672a\u914d\u7f6e\u7684\u5e94\u7528", (Object)applicationName);
            throw new ParamCheckException("\u672a\u914d\u7f6e\u7684\u5e94\u7528");
        }
        AccessTokenResponse accessTokenResponse = this.weChatClient.getAccessToken(StringUtils.defaultString((String)app.getCorpId(), (String)this.properties.getCorpId()), app.getSecret());
        return accessTokenResponse.getAccessToken();
    }

    @CacheEvict(value={"qywx"}, key="'qywx_access_token_'+#cacheApplicationName")
    public void clearAccessToken(String cacheApplicationName) {
    }
}

