/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.service;

import com.github.shuaidd.exception.ParamCheckException;
import com.github.shuaidd.exception.WeChatException;
import com.github.shuaidd.response.kf.AddKfAccountResponse;
import com.github.shuaidd.response.kf.AddKnowledgeGroupResponse;
import com.github.shuaidd.response.kf.ChangeServiceStateResponse;
import com.github.shuaidd.response.kf.GetCustomerResponse;
import com.github.shuaidd.response.kf.KfAccountListResponse;
import com.github.shuaidd.response.kf.KfAddContactWayResponse;
import com.github.shuaidd.response.kf.KnowledgeGroupResponse;
import com.github.shuaidd.response.kf.KnowledgeIntentResponse;
import com.github.shuaidd.response.kf.SendMsgResponse;
import com.github.shuaidd.response.kf.ServiceStateResponse;
import com.github.shuaidd.response.kf.ServicerListResponse;
import com.github.shuaidd.response.kf.ServicerResponse;
import com.github.shuaidd.response.kf.SyncMsgResponse;
import com.github.shuaidd.response.kf.UpgradeServiceConfigResponse;
import com.github.shuaidd.resquest.kf.CancelUpgradeServiceRequest;
import com.github.shuaidd.resquest.kf.ChangeServiceStateRequest;
import com.github.shuaidd.resquest.kf.DelKfAccountRequest;
import com.github.shuaidd.resquest.kf.DelKnowledgeGroupRequest;
import com.github.shuaidd.resquest.kf.DelKnowledgeIntentRequest;
import com.github.shuaidd.resquest.kf.GetCustomerRequest;
import com.github.shuaidd.resquest.kf.KfAccountRequest;
import com.github.shuaidd.resquest.kf.KfAddContactWayRequest;
import com.github.shuaidd.resquest.kf.KnowledgeGroupRequest;
import com.github.shuaidd.resquest.kf.KnowledgeIntentRequest;
import com.github.shuaidd.resquest.kf.QueryKnowledgeGroupRequest;
import com.github.shuaidd.resquest.kf.QueryKnowledgeIntentRequest;
import com.github.shuaidd.resquest.kf.SendMsgOnEventRequest;
import com.github.shuaidd.resquest.kf.SendMsgRequest;
import com.github.shuaidd.resquest.kf.ServiceStateRequest;
import com.github.shuaidd.resquest.kf.ServicerRequest;
import com.github.shuaidd.resquest.kf.SyncMsgRequest;
import com.github.shuaidd.resquest.kf.UpgradeServiceRequest;
import com.github.shuaidd.service.AbstractBaseService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class WeChatCallCenterService
extends AbstractBaseService {
    public String addKfAccount(String name, String mediaId, String applicationName) {
        if (StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)mediaId)) {
            throw new WeChatException("\u5ba2\u670d\u540d\u79f0\u6216\u5934\u50cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        KfAccountRequest request = new KfAccountRequest();
        request.setMediaId(mediaId);
        request.setName(name);
        AddKfAccountResponse response = this.callCenterClient.addKfAccount(request, applicationName);
        return response.getOpenKfId();
    }

    public void updateKfAccount(KfAccountRequest request, String applicationName) {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getOpenKfId())) {
            throw new WeChatException("\u8bf7\u6c42\u4fe1\u606f\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isEmpty((CharSequence)request.getMediaId()) && StringUtils.isEmpty((CharSequence)request.getName())) {
            throw new WeChatException("\u5ba2\u670d\u540d\u79f0\u6216\u5934\u50cf\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        this.callCenterClient.updateKfAccount(request, applicationName);
    }

    public void delKfAccount(String kfId, String applicationName) {
        if (StringUtils.isEmpty((CharSequence)kfId)) {
            throw new WeChatException("\u5ba2\u670d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DelKfAccountRequest request = new DelKfAccountRequest();
        request.setOpenKfId(kfId);
        this.callCenterClient.delKfAccount(request, applicationName);
    }

    public KfAccountListResponse getAccountList(String applicationName) {
        return this.callCenterClient.kfAccountLIst(applicationName);
    }

    public String kfContactWay(String kfId, String scene, String applicationName) {
        if (StringUtils.isEmpty((CharSequence)kfId)) {
            throw new WeChatException("\u5ba2\u670d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        KfAddContactWayRequest request = new KfAddContactWayRequest();
        request.setOpenKfId(kfId);
        request.setScene(scene);
        KfAddContactWayResponse response = this.callCenterClient.kfContactWay(request, applicationName);
        return response.getUrl();
    }

    public List<ServicerResponse.ResultDetail> addServicer(ServicerRequest request, String applicationName) {
        ServicerResponse response = this.callCenterClient.addServicer(request, applicationName);
        return response.getResultList();
    }

    public List<ServicerResponse.ResultDetail> delServicer(ServicerRequest request, String applicationName) {
        ServicerResponse response = this.callCenterClient.delServicer(request, applicationName);
        return response.getResultList();
    }

    public List<ServicerListResponse.Servicer> getServicerList(String openKfId, String applicationName) {
        ServicerListResponse response = this.callCenterClient.getServicerList(openKfId, applicationName);
        return response.getServicerList();
    }

    public ServiceStateResponse getServiceState(ServiceStateRequest request, String applicationName) {
        return this.callCenterClient.getServiceState(request, applicationName);
    }

    public String changeServiceState(ChangeServiceStateRequest request, String applicationName) {
        ChangeServiceStateResponse response = this.callCenterClient.changeServiceState(request, applicationName);
        return response.getMsgCode();
    }

    public SyncMsgResponse syncMsg(SyncMsgRequest request, String applicationName) {
        return this.callCenterClient.syncMsg(request, applicationName);
    }

    public String sendMsg(SendMsgRequest msg, String applicationName) {
        SendMsgResponse response = this.callCenterClient.sendMsg(msg, applicationName);
        return response.getMsgId();
    }

    public String sendMsgOnEvent(SendMsgOnEventRequest msg, String applicationName) {
        SendMsgResponse response = this.callCenterClient.sendMsgOnEvent(msg, applicationName);
        return response.getMsgId();
    }

    public GetCustomerResponse getCustomer(GetCustomerRequest request, String applicationName) {
        return this.callCenterClient.getCustomer(request, applicationName);
    }

    public UpgradeServiceConfigResponse getUpgradeServiceConfig(String applicationName) {
        return this.callCenterClient.getUpgradeServiceConfig(applicationName);
    }

    public void upgradeService(UpgradeServiceRequest request, String applicationName) {
        this.callCenterClient.upgradeService(request, applicationName);
    }

    public void cancelUpgradeService(CancelUpgradeServiceRequest request, String applicationName) {
        this.callCenterClient.cancelUpgradeService(request, applicationName);
    }

    public String addKnowledgeGroup(String name, String applicationName) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new ParamCheckException("\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        KnowledgeGroupRequest request = new KnowledgeGroupRequest();
        request.setName(name);
        AddKnowledgeGroupResponse response = this.callCenterClient.addKnowledgeGroup(request, applicationName);
        return response.getGroupId();
    }

    public void modKnowledgeGroup(KnowledgeGroupRequest request, String applicationName) {
        this.callCenterClient.modKnowledgeGroup(request, applicationName);
    }

    public void delKnowledgeGroup(String groupId, String applicationName) {
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            throw new ParamCheckException("\u5206\u7ec4\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DelKnowledgeGroupRequest request = new DelKnowledgeGroupRequest();
        request.setGroupId(groupId);
        this.callCenterClient.delKnowledgeGroup(request, applicationName);
    }

    public KnowledgeGroupResponse queryKnowledgeGroup(QueryKnowledgeGroupRequest request, String applicationName) {
        return this.callCenterClient.queryKnowledgeGroup(request, applicationName);
    }

    public String addKnowledgeIntent(KnowledgeIntentRequest request, String applicationName) {
        return this.callCenterClient.addKnowledgeIntent(request, applicationName).getIntentId();
    }

    public void modKnowledgeIntent(KnowledgeIntentRequest request, String applicationName) {
        this.callCenterClient.modKnowledgeIntent(request, applicationName);
    }

    public void delKnowledgeIntent(String intentId, String applicationName) {
        if (StringUtils.isEmpty((CharSequence)intentId)) {
            throw new ParamCheckException("\u95ee\u7b54\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DelKnowledgeIntentRequest request = new DelKnowledgeIntentRequest();
        request.setIntentId(intentId);
        this.callCenterClient.delKnowledgeIntent(request, applicationName);
    }

    public KnowledgeIntentResponse queryKnowledgeIntent(QueryKnowledgeIntentRequest request, String applicationName) {
        return this.callCenterClient.queryKnowledgeIntent(request, applicationName);
    }
}

