/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.support;

import com.github.shuaidd.callback.AbstractCallBackChain;
import com.github.shuaidd.callback.AesException;
import com.github.shuaidd.callback.WXBizMsgXmlCrypt;
import com.github.shuaidd.client.config.CallbackProperties;
import com.github.shuaidd.event.BaseEventData;
import com.github.shuaidd.exception.WeChatException;
import com.github.shuaidd.support.EventDataManager;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CallBackManager {
    private static final Logger logger = LoggerFactory.getLogger(CallBackManager.class);
    private static AbstractCallBackChain first;
    private static AbstractCallBackChain last;
    private static List<CallbackProperties> CALLBACK_LIST;

    public static void properties(List<CallbackProperties> callbackList) {
        CALLBACK_LIST = callbackList;
    }

    public static synchronized void registerCallBack(AbstractCallBackChain callBackChain) {
        if (Objects.nonNull(callBackChain) && CallBackManager.canRegister(callBackChain)) {
            if (Objects.isNull(first)) {
                first = callBackChain;
                last = callBackChain;
            } else {
                last.setNext(callBackChain);
                last = callBackChain;
            }
        }
    }

    private static boolean canRegister(AbstractCallBackChain callBackChain) {
        if (Objects.isNull(first)) {
            return true;
        }
        for (AbstractCallBackChain next = first; next != null; next = next.getNext()) {
            if (next != callBackChain) continue;
            throw new RuntimeException("\u4e00\u4e2a\u5904\u7406\u7c7b\u53ea\u80fd\u6ce8\u518c\u4e00\u6b21");
        }
        return true;
    }

    public static BaseEventData handle(String applicationName, String xml, String msgSignature, String timestamp, String nonce) throws AesException {
        CallbackProperties properties = CallBackManager.getCallbackProperty(applicationName);
        if (Objects.isNull(properties)) {
            logger.error("\u5e94\u7528-{}-\u672a\u914d\u7f6e\u5bc6\u94a5\u4fe1\u606f\uff0c\u65e0\u6cd5\u5904\u7406", (Object)applicationName);
            throw new WeChatException("\u5e94\u7528-" + applicationName + "-\u672a\u914d\u7f6e\u5bc6\u94a5\u4fe1\u606f\uff0c\u65e0\u6cd5\u5904\u7406");
        }
        WXBizMsgXmlCrypt crypt = new WXBizMsgXmlCrypt(properties.getToken(), properties.getEncodingAesKey(), properties.getReceiveId());
        if (StringUtils.isNotEmpty((CharSequence)xml)) {
            if (logger.isInfoEnabled()) {
                logger.info("\u63a5\u6536\u5230\u7684postData--{}", (Object)xml);
            }
            String data = crypt.DecryptMsg(msgSignature, timestamp, nonce, xml);
            if (logger.isInfoEnabled()) {
                logger.info("\u62ff\u5230\u7684\u660e\u6587\u4fe1\u606f---{}", (Object)data);
            }
            BaseEventData eventData = EventDataManager.getXmlData(data);
            if (logger.isInfoEnabled()) {
                logger.info("BaseEventData -- {}", (Object)eventData);
            }
            if (Objects.nonNull(first)) {
                first.handleData(applicationName, eventData);
            }
            return eventData;
        }
        throw new WeChatException("\u6d88\u606f\u4f53\u4fe1\u606f\u4e3a\u7a7a");
    }

    public static String verifyUrl(String applicationName, String msgSignature, String timestamp, String nonce, String echoStr) throws AesException {
        CallbackProperties properties = CallBackManager.getCallbackProperty(applicationName);
        if (Objects.isNull(properties)) {
            logger.error("\u5e94\u7528-{}-\u672a\u914d\u7f6e\u5bc6\u94a5\u4fe1\u606f\uff0c\u65e0\u6cd5\u5904\u7406", (Object)applicationName);
            return "";
        }
        WXBizMsgXmlCrypt crypt = new WXBizMsgXmlCrypt(properties.getToken(), properties.getEncodingAesKey(), properties.getReceiveId());
        return crypt.VerifyURL(msgSignature, timestamp, nonce, echoStr);
    }

    private static CallbackProperties getCallbackProperty(String applicationName) {
        if (Objects.nonNull(CALLBACK_LIST) && CALLBACK_LIST.size() > 0) {
            for (CallbackProperties callbackProperties : CALLBACK_LIST) {
                if (callbackProperties.getApplicationName() == null || !callbackProperties.getApplicationName().equals(applicationName)) continue;
                return callbackProperties;
            }
        }
        return null;
    }

    public static String msgEncrypt(String applicationName, String text) throws AesException {
        CallbackProperties properties = CallBackManager.getCallbackProperty(applicationName);
        if (Objects.isNull(properties)) {
            logger.error("\u5e94\u7528-{}-\u672a\u914d\u7f6e\u5bc6\u94a5\u4fe1\u606f\uff0c\u65e0\u6cd5\u5904\u7406", (Object)applicationName);
            throw new RuntimeException("\u672a\u914d\u7f6e\u5bc6\u94a5\u4fe1\u606f");
        }
        WXBizMsgXmlCrypt crypt = new WXBizMsgXmlCrypt(properties.getToken(), properties.getEncodingAesKey(), properties.getReceiveId());
        return crypt.EncryptMsg(text, System.currentTimeMillis() + "", RandomStringUtils.random((int)10, (boolean)true, (boolean)true));
    }
}

