/*
 * Decompiled with CFR 0.152.
 */
package com.github.shuaidd.support;

import com.github.shuaidd.enums.ChangeType;
import com.github.shuaidd.enums.MsgType;
import com.github.shuaidd.event.BaseEventData;
import com.github.shuaidd.event.BatchJobResultEventData;
import com.github.shuaidd.event.CalendarEventData;
import com.github.shuaidd.event.CommonEventData;
import com.github.shuaidd.event.DeleteUserEventData;
import com.github.shuaidd.event.ExternalContactChatEventData;
import com.github.shuaidd.event.ExternalContactEventData;
import com.github.shuaidd.event.ExternalTagEventData;
import com.github.shuaidd.event.ImageMsgEventData;
import com.github.shuaidd.event.KfMsgOrEventData;
import com.github.shuaidd.event.LinkMsgEventData;
import com.github.shuaidd.event.LivingStatusChangeEventData;
import com.github.shuaidd.event.LocationEventData;
import com.github.shuaidd.event.LocationMsgEventData;
import com.github.shuaidd.event.LocationSelectEventData;
import com.github.shuaidd.event.OpenApprovalChangeEventData;
import com.github.shuaidd.event.PicSysPhotoEventData;
import com.github.shuaidd.event.ScanCodeEventData;
import com.github.shuaidd.event.ScheduleEventData;
import com.github.shuaidd.event.SysApprovalChangeEventData;
import com.github.shuaidd.event.TagChangeEventData;
import com.github.shuaidd.event.TaskCardEventData;
import com.github.shuaidd.event.TextMsgEventData;
import com.github.shuaidd.event.UnitEventData;
import com.github.shuaidd.event.UserEventData;
import com.github.shuaidd.event.VideoMsgEventData;
import com.github.shuaidd.event.VoiceMsgEventData;
import com.github.shuaidd.support.XMLUtil;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDataManager {
    private static final Logger logger = LoggerFactory.getLogger(EventDataManager.class);
    private static final HashMap<ChangeType, Class<? extends BaseEventData>> DATA_TYPE_MAP = new HashMap();

    public static <T extends BaseEventData> T getXmlData(String xml, Class<T> tClass) {
        if (StringUtils.isEmpty((CharSequence)xml)) {
            return null;
        }
        CommonEventData commonEventData = XMLUtil.convertXmlStrToObject(CommonEventData.class, xml);
        if (StringUtils.isEmpty((CharSequence)commonEventData.getChangeType())) {
            return null;
        }
        return (T)((BaseEventData)XMLUtil.convertXmlStrToObject(tClass, xml));
    }

    public static BaseEventData getXmlData(String xml) {
        if (StringUtils.isEmpty((CharSequence)xml)) {
            return null;
        }
        CommonEventData commonEventData = XMLUtil.convertXmlStrToObject(CommonEventData.class, xml);
        Class<TextMsgEventData> cls = null;
        if (MsgType.TEXT.getType().equals(commonEventData.getMsgType())) {
            cls = TextMsgEventData.class;
        }
        if (MsgType.IMAGE.getType().equals(commonEventData.getMsgType())) {
            cls = ImageMsgEventData.class;
        }
        if (MsgType.VOICE.getType().equals(commonEventData.getMsgType())) {
            cls = VoiceMsgEventData.class;
        }
        if (MsgType.VIDEO.getType().equals(commonEventData.getMsgType())) {
            cls = VideoMsgEventData.class;
        }
        if (MsgType.LOCATION.getType().equals(commonEventData.getMsgType())) {
            cls = LocationMsgEventData.class;
        }
        if (MsgType.LINK.getType().equals(commonEventData.getMsgType())) {
            cls = LinkMsgEventData.class;
        }
        if (MsgType.EVENT.getType().equals(commonEventData.getMsgType())) {
            for (ChangeType changeType : DATA_TYPE_MAP.keySet()) {
                if (!changeType.getEventType().getEvent().equals(commonEventData.getEvent())) continue;
                if (StringUtils.isNotEmpty((CharSequence)changeType.getChangeType())) {
                    if (!changeType.getChangeType().equals(commonEventData.getChangeType())) continue;
                    cls = DATA_TYPE_MAP.get(changeType);
                    continue;
                }
                cls = DATA_TYPE_MAP.get(changeType);
            }
        }
        if (cls == null) {
            logger.error("--------\u65e0\u6cd5\u83b7\u53d6\u8f6c\u6362\u5bf9\u8c61-------");
            commonEventData.setDecryptMsg(xml);
            return commonEventData;
        }
        BaseEventData eventData = (BaseEventData)XMLUtil.convertXmlStrToObject(cls, xml);
        eventData.setDecryptMsg(xml);
        return eventData;
    }

    static {
        DATA_TYPE_MAP.put(ChangeType.CREATE_USER, UserEventData.class);
        DATA_TYPE_MAP.put(ChangeType.UPDATE_USER, UserEventData.class);
        DATA_TYPE_MAP.put(ChangeType.DELETE_USER, DeleteUserEventData.class);
        DATA_TYPE_MAP.put(ChangeType.CREATE_PARTY, UnitEventData.class);
        DATA_TYPE_MAP.put(ChangeType.UPDATE_PARTY, UnitEventData.class);
        DATA_TYPE_MAP.put(ChangeType.DELETE_PARTY, UnitEventData.class);
        DATA_TYPE_MAP.put(ChangeType.UPDATE_TAG, TagChangeEventData.class);
        DATA_TYPE_MAP.put(ChangeType.BATCH_JOB_RESULT, BatchJobResultEventData.class);
        DATA_TYPE_MAP.put(ChangeType.ADD_EXTERNAL_CONTACT, ExternalContactEventData.class);
        DATA_TYPE_MAP.put(ChangeType.EDIT_EXTERNAL_CONTACT, ExternalContactEventData.class);
        DATA_TYPE_MAP.put(ChangeType.ADD_HALF_EXTERNAL_CONTACT, ExternalContactEventData.class);
        DATA_TYPE_MAP.put(ChangeType.DEL_EXTERNAL_CONTACT, ExternalContactEventData.class);
        DATA_TYPE_MAP.put(ChangeType.DEL_FOLLOW_USER, ExternalContactEventData.class);
        DATA_TYPE_MAP.put(ChangeType.TRANSFER_FAIL, ExternalContactEventData.class);
        DATA_TYPE_MAP.put(ChangeType.CREATE_CHAT, ExternalContactChatEventData.class);
        DATA_TYPE_MAP.put(ChangeType.UPDATE_CHAT, ExternalContactChatEventData.class);
        DATA_TYPE_MAP.put(ChangeType.DISMISS_CHAT, ExternalContactChatEventData.class);
        DATA_TYPE_MAP.put(ChangeType.CREATE_EXTERNAL_TAG, ExternalTagEventData.class);
        DATA_TYPE_MAP.put(ChangeType.UPDATE_EXTERNAL_TAG, ExternalTagEventData.class);
        DATA_TYPE_MAP.put(ChangeType.DELETE_EXTERNAL_TAG, ExternalTagEventData.class);
        DATA_TYPE_MAP.put(ChangeType.SUBSCRIBE, CommonEventData.class);
        DATA_TYPE_MAP.put(ChangeType.UNSUBSCRIBE, CommonEventData.class);
        DATA_TYPE_MAP.put(ChangeType.ENTER_AGENT, CommonEventData.class);
        DATA_TYPE_MAP.put(ChangeType.LOCATION, LocationEventData.class);
        DATA_TYPE_MAP.put(ChangeType.CLICK, CommonEventData.class);
        DATA_TYPE_MAP.put(ChangeType.VIEW, CommonEventData.class);
        DATA_TYPE_MAP.put(ChangeType.SCAN_CODE_PUSH, ScanCodeEventData.class);
        DATA_TYPE_MAP.put(ChangeType.SCAN_CODE_WAIT_MSG, ScanCodeEventData.class);
        DATA_TYPE_MAP.put(ChangeType.PIC_SYS_PHOTO, PicSysPhotoEventData.class);
        DATA_TYPE_MAP.put(ChangeType.PIC_PHOTO_OR_ALBUM, PicSysPhotoEventData.class);
        DATA_TYPE_MAP.put(ChangeType.PIC_WEI_XIN, PicSysPhotoEventData.class);
        DATA_TYPE_MAP.put(ChangeType.LOCATION_SELECT, LocationSelectEventData.class);
        DATA_TYPE_MAP.put(ChangeType.OPEN_APPROVAL_CHANGE, OpenApprovalChangeEventData.class);
        DATA_TYPE_MAP.put(ChangeType.SYS_APPROVAL_CHANGE, SysApprovalChangeEventData.class);
        DATA_TYPE_MAP.put(ChangeType.TASK_CARD_CLICK, TaskCardEventData.class);
        DATA_TYPE_MAP.put(ChangeType.SHARE_AGENT_CHANGE, CommonEventData.class);
        DATA_TYPE_MAP.put(ChangeType.MODIFY_CALENDAR, CalendarEventData.class);
        DATA_TYPE_MAP.put(ChangeType.DELETE_CALENDAR, CalendarEventData.class);
        DATA_TYPE_MAP.put(ChangeType.ADD_SCHEDULE, ScheduleEventData.class);
        DATA_TYPE_MAP.put(ChangeType.MODIFY_SCHEDULE, ScheduleEventData.class);
        DATA_TYPE_MAP.put(ChangeType.DELETE_SCHEDULE, ScheduleEventData.class);
        DATA_TYPE_MAP.put(ChangeType.LIVING_STATUS_CHANGE, LivingStatusChangeEventData.class);
        DATA_TYPE_MAP.put(ChangeType.KF_MSG_OR_EVENT, KfMsgOrEventData.class);
    }
}

