/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.color;

import com.github.weisj.darklaf.components.chooser.ChooserComponent;
import com.github.weisj.darklaf.components.color.SmallColorChooser;
import com.github.weisj.darklaf.components.popup.AttachedPopupComponent;
import com.github.weisj.darklaf.components.popup.SharedComponent;
import com.github.weisj.darklaf.util.Lambdas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class PopupColorChooser
extends JPanel
implements ChooserComponent<Color> {
    private static final SharedComponent<SmallColorChooser> sharedChooser = new SharedComponent<SmallColorChooser>(SmallColorChooser::new);
    private final SmallColorChooser chooser;

    protected SmallColorChooser getChooser(Color initial, Consumer<Color> callback) {
        SmallColorChooser smallColorChooser = sharedChooser.get();
        smallColorChooser.reset(initial, callback);
        return smallColorChooser;
    }

    public PopupColorChooser(Color initial, Consumer<Color> callback) {
        this.setLayout(new BorderLayout());
        this.chooser = this.getChooser(initial, callback);
        this.add((Component)this.chooser, "Center");
        this.setBackground(UIManager.getColor("ColorChooser.background"));
    }

    @Override
    public void reset(Color initial, Consumer<Color> callback) {
        this.chooser.reset(initial, callback);
    }

    @Override
    public Color getInitial() {
        return this.chooser.getInitial();
    }

    @Override
    public Color getSelected() {
        return this.chooser.getSelected();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("ColorChooser.background"));
    }

    public static void attackToComponent(JComponent component, Consumer<Color> callback, Supplier<Color> supplier, Supplier<Boolean> activationCheck, boolean revertOnAbort) {
        AttachedPopupComponent.attachChooser(component, () -> {
            if (!((Boolean)activationCheck.get()).booleanValue()) {
                return null;
            }
            return new PopupColorChooser((Color)supplier.get(), callback);
        }, callback, supplier, revertOnAbort);
    }

    public static void showColorChooser(JComponent parent, Color initial, Consumer<Color> callback, Runnable onClose) {
        PopupColorChooser.showColorChooser(parent, initial, callback, onClose, false);
    }

    public static void showColorChooser(JComponent parent, Color initial, Consumer<Color> callback, Runnable onClose, boolean revertOnEscape) {
        PopupColorChooser chooser = new PopupColorChooser(initial, callback);
        AttachedPopupComponent.showComponent(parent, chooser, onClose, () -> {
            if (revertOnEscape) {
                callback.accept(initial);
            }
            onClose.run();
        }, Lambdas.DO_NOTHING);
    }
}

