/*
 * MIT License
 *
 * Copyright (c) 2021 Jannis Weis
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */
package com.github.weisj.darklaf.components.tristate;

public enum TristateState {
    SELECTED(false) {
        public TristateState next() {
            return DESELECTED;
        }
    },
    INDETERMINATE_SEL(true) {
        public TristateState next() {
            return SELECTED;
        }
    },
    INDETERMINATE_DES(true) {
        public TristateState next() {
            return DESELECTED;
        }
    },
    DESELECTED(false) {
        public TristateState next() {
            return INDETERMINATE_SEL;
        }
    };

    TristateState(final boolean indeterminate) {
        this.indeterminate = indeterminate;
    }

    public abstract TristateState next();

    private final boolean indeterminate;

    public boolean isIndeterminate() {
        return indeterminate;
    }
}
