/*
 * MIT License
 *
 * Copyright (c) 2021 Jannis Weis
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */
package com.github.weisj.darklaf.ui.table.renderer;

import java.awt.*;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;

import com.github.weisj.darklaf.color.ColorUtil;

/** @author Jannis Weis */
public class DarkTableCellRenderer extends DefaultTableCellRenderer {

    @Override
    public Component getTableCellRendererComponent(final JTable table, final Object value, final boolean isSelected,
            final boolean hasFocus, final int row, final int column) {
        setBackground(null);
        Object effectiveValue = value;
        if (value instanceof Color) {
            effectiveValue = "";
        }
        Component component =
                super.getTableCellRendererComponent(table, effectiveValue, isSelected, hasFocus, row, column);
        if (value instanceof Color) {
            component.setBackground(ColorUtil.stripUIResource((Color) value, false));
        }
        int horizontalAlignment =
                table.getComponentOrientation().isLeftToRight() ? SwingConstants.LEFT : SwingConstants.RIGHT;

        if (component instanceof JLabel) {
            ((JLabel) component).setHorizontalAlignment(horizontalAlignment);
        } else if (component instanceof AbstractButton) {
            ((AbstractButton) component).setHorizontalAlignment(horizontalAlignment);
        }
        return component;
    }
}
