/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.graphics;

import com.github.weisj.darklaf.graphics.DefaultInterpolator;
import com.github.weisj.darklaf.graphics.Interpolator;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class Animator {
    public static final String ANIMATIONS_FLAG = "darklaf.animations";
    private static final ScheduledExecutorService scheduler = Animator.createScheduler();
    private final int totalFrames;
    private final int cycleDuration;
    private final boolean repeatable;
    private final int delay;
    private boolean forward;
    private Interpolator interpolator;
    private ScheduledFuture<?> ticker;
    private int startFrame;
    private int currentFrame;
    private long startTime;
    private long stopTime;
    private boolean enabled = true;
    private volatile boolean disposed = false;

    public Animator(int totalFrames, int cycleDuration, int delay) {
        this(totalFrames, cycleDuration, delay, false);
    }

    public Animator(int totalFrames, int cycleDuration, int delay, boolean repeatable) {
        this(totalFrames, cycleDuration, delay, repeatable, true, DefaultInterpolator.LINEAR);
    }

    public Animator(int totalFrames, int cycleDuration, boolean repeatable) {
        this(totalFrames, cycleDuration, 0, repeatable, true, DefaultInterpolator.LINEAR);
    }

    public Animator(int totalFrames, int cycleDuration, boolean repeatable, Interpolator interpolator) {
        this(totalFrames, cycleDuration, 0, repeatable, true, interpolator);
    }

    public Animator(int totalFrames, int cycleDuration, int delay, boolean repeatable, boolean forward, Interpolator interpolator) {
        this.totalFrames = totalFrames;
        this.cycleDuration = cycleDuration;
        this.delay = delay;
        this.repeatable = repeatable;
        this.forward = forward;
        this.interpolator = interpolator;
        this.currentFrame = forward ? 0 : totalFrames;
        this.resetTime();
        this.reset();
    }

    public void setForward(boolean forward) {
        this.forward = forward;
    }

    private void resetTime() {
        this.startTime = -1L;
    }

    public void reset() {
        this.currentFrame %= this.totalFrames;
    }

    private static ScheduledExecutorService createScheduler() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = new Thread(r, "Animations Thread");
            thread.setDaemon(true);
            thread.setPriority(10);
            return thread;
        });
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return executor;
    }

    public void suspend() {
        this.resetTime();
        this.reset();
        this.stopTicker();
    }

    public void stopTicker() {
        if (this.ticker != null) {
            this.ticker.cancel(false);
            this.ticker = null;
        }
    }

    public void resume() {
        this.resume(0, false);
    }

    private boolean animationsEnabled() {
        return this.enabled && PropertyUtil.getSystemFlag((String)ANIMATIONS_FLAG);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void stopAnimation() {
        this.currentFrame = this.totalFrames - 1;
        this.paint();
        this.animationDone();
    }

    public void resume(int startFrame, boolean skipDelay, JComponent target) {
        if (!(target == null || target.isVisible() && target.isShowing())) {
            this.stopAnimation();
            return;
        }
        this.resume(startFrame, skipDelay);
    }

    public void resume(int startFrame, boolean skipDelay) {
        if (startFrame < 0) {
            throw new IllegalArgumentException("Starting frame must be non negative.");
        }
        if (this.cycleDuration == 0 || startFrame >= this.totalFrames || !this.animationsEnabled()) {
            this.stopAnimation();
        } else if (this.ticker == null) {
            this.startFrame = startFrame;
            long initialDelay = skipDelay ? 0L : (long)this.delay * 1000L;
            this.ticker = scheduler.scheduleWithFixedDelay(new Runnable(){
                final AtomicBoolean isScheduled = new AtomicBoolean(false);

                @Override
                public void run() {
                    if (!this.isScheduled.get() && !Animator.this.isDisposed()) {
                        this.isScheduled.set(true);
                        SwingUtilities.invokeLater(() -> {
                            Animator.this.onTick();
                            this.isScheduled.set(false);
                        });
                    }
                }
            }, initialDelay, (long)this.cycleDuration * 1000L / (long)this.totalFrames, TimeUnit.MICROSECONDS);
        }
    }

    private void paint() {
        int frame = this.forward ? this.currentFrame : this.totalFrames - this.currentFrame - 1;
        this.paintNow(this.interpolator.interpolate((float)frame / (float)this.totalFrames));
    }

    private void animationDone() {
        this.stopTicker();
        SwingUtilities.invokeLater(this::paintCycleEnd);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private void onTick() {
        if (this.isDisposed() || this.ticker == null) {
            return;
        }
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
            this.stopTime = this.startTime + (long)this.cycleDuration * (long)(this.totalFrames - this.currentFrame) / (long)this.totalFrames;
        }
        double passedTime = System.currentTimeMillis() - this.startTime;
        double totalTime = this.stopTime - this.startTime;
        int newFrame = (int)(passedTime * (double)this.totalFrames / totalTime) + this.startFrame;
        if (this.currentFrame > 0 && newFrame == this.currentFrame) {
            return;
        }
        this.currentFrame = newFrame;
        if (this.currentFrame >= this.totalFrames) {
            if (this.repeatable) {
                this.reset();
            } else {
                this.animationDone();
                return;
            }
        }
        this.paint();
    }

    public abstract void paintNow(float var1);

    protected void paintCycleEnd() {
    }

    public void dispose() {
        this.disposed = true;
        this.stopTicker();
    }

    public boolean isRunning() {
        return this.ticker != null;
    }

    public final boolean isForward() {
        return this.forward;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public int getTotalFrames() {
        return this.totalFrames;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }
}

