/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ComponentCreatorKind;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ComponentCreatorAnnotation {
    COMPONENT_BUILDER(XTypeNames.COMPONENT_BUILDER),
    COMPONENT_FACTORY(XTypeNames.COMPONENT_FACTORY),
    SUBCOMPONENT_BUILDER(XTypeNames.SUBCOMPONENT_BUILDER),
    SUBCOMPONENT_FACTORY(XTypeNames.SUBCOMPONENT_FACTORY),
    PRODUCTION_COMPONENT_BUILDER(XTypeNames.PRODUCTION_COMPONENT_BUILDER),
    PRODUCTION_COMPONENT_FACTORY(XTypeNames.PRODUCTION_COMPONENT_FACTORY),
    PRODUCTION_SUBCOMPONENT_BUILDER(XTypeNames.PRODUCTION_SUBCOMPONENT_BUILDER),
    PRODUCTION_SUBCOMPONENT_FACTORY(XTypeNames.PRODUCTION_SUBCOMPONENT_FACTORY);

    private final XClassName annotation;
    private final ComponentCreatorKind creatorKind;
    private final XClassName componentAnnotation;

    private ComponentCreatorAnnotation(XClassName annotation) {
        this.annotation = annotation;
        this.creatorKind = ComponentCreatorKind.valueOf(Ascii.toUpperCase((String)annotation.getSimpleName()));
        this.componentAnnotation = XTypeNames.enclosingClassName(annotation);
    }

    public XClassName annotation() {
        return this.annotation;
    }

    public final XClassName componentAnnotation() {
        return this.componentAnnotation;
    }

    public final boolean isSubcomponentCreatorAnnotation() {
        return this.componentAnnotation().getSimpleName().endsWith("Subcomponent");
    }

    public final boolean isProductionCreatorAnnotation() {
        return this.componentAnnotation().getSimpleName().startsWith("Production");
    }

    public ComponentCreatorKind creatorKind() {
        return this.creatorKind;
    }

    public final String toString() {
        return this.annotation().getCanonicalName();
    }

    public final String simpleName() {
        return this.annotation().getSimpleName();
    }

    public static ImmutableSet<XClassName> allCreatorAnnotations() {
        return ComponentCreatorAnnotation.stream().collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<XClassName> rootComponentCreatorAnnotations() {
        return ComponentCreatorAnnotation.stream().filter(componentCreatorAnnotation -> !componentCreatorAnnotation.isSubcomponentCreatorAnnotation()).collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<XClassName> subcomponentCreatorAnnotations() {
        return ComponentCreatorAnnotation.stream().filter(componentCreatorAnnotation -> componentCreatorAnnotation.isSubcomponentCreatorAnnotation()).collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<XClassName> productionCreatorAnnotations() {
        return ComponentCreatorAnnotation.stream().filter(componentCreatorAnnotation -> componentCreatorAnnotation.isProductionCreatorAnnotation()).collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<XClassName> creatorAnnotationsFor(ComponentAnnotation componentAnnotation) {
        return ComponentCreatorAnnotation.stream().filter(creatorAnnotation -> creatorAnnotation.componentAnnotation().getSimpleName().equals(componentAnnotation.simpleName())).collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<ComponentCreatorAnnotation> getCreatorAnnotations(XTypeElement type) {
        return (ImmutableSet)ComponentCreatorAnnotation.stream().filter(cca -> type.hasAnnotation(cca.annotation())).collect(DaggerStreams.toImmutableSet());
    }

    private static Stream<ComponentCreatorAnnotation> stream() {
        return DaggerStreams.valuesOf(ComponentCreatorAnnotation.class);
    }

    private static Collector<ComponentCreatorAnnotation, ?, ImmutableSet<XClassName>> toAnnotationClasses() {
        return Collectors.mapping(ComponentCreatorAnnotation::annotation, DaggerStreams.toImmutableSet());
    }
}

