/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.binding.AutoValue_BindingNode;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.Declaration;
import dagger.internal.codegen.binding.DeclarationFormatter;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.binding.OptionalBindingDeclaration;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.ComponentPath;
import dagger.internal.codegen.model.DaggerElement;
import dagger.internal.codegen.model.DaggerTypeElement;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import java.util.Optional;
import javax.inject.Inject;

@AutoValue
public abstract class BindingNode
implements dagger.internal.codegen.model.Binding {
    private DeclarationFormatter declarationFormatter;

    public abstract Binding delegate();

    public abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    public abstract ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations();

    public abstract ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations();

    public final Iterable<Declaration> associatedDeclarations() {
        return Iterables.concat(this.multibindingDeclarations(), this.optionalBindingDeclarations(), this.subcomponentDeclarations());
    }

    @Override
    public Key key() {
        return this.delegate().key();
    }

    @Override
    public ImmutableSet<DependencyRequest> dependencies() {
        return this.delegate().dependencies();
    }

    @Override
    public Optional<DaggerElement> bindingElement() {
        return this.delegate().bindingElement().map(DaggerElement::from);
    }

    @Override
    public Optional<DaggerTypeElement> contributingModule() {
        return this.delegate().contributingModule().map(DaggerTypeElement::from);
    }

    @Override
    public boolean requiresModuleInstance() {
        return this.delegate().requiresModuleInstance();
    }

    @Override
    public Optional<Scope> scope() {
        return this.delegate().scope();
    }

    @Override
    public boolean isNullable() {
        return this.delegate().isNullable();
    }

    @Override
    public boolean isProduction() {
        return this.delegate().bindingType().equals((Object)BindingType.PRODUCTION);
    }

    @Override
    public BindingKind kind() {
        return this.delegate().kind();
    }

    public final String toString() {
        return this.declarationFormatter.format(this.delegate());
    }

    public BindingNode withBindingType(BindingType bindingType) {
        return BindingNode.create(this.componentPath(), ((ContributionBinding)this.delegate()).withBindingType(bindingType), this.multibindingDeclarations(), this.optionalBindingDeclarations(), this.subcomponentDeclarations(), this.declarationFormatter);
    }

    private static BindingNode create(ComponentPath component, Binding delegate, ImmutableSet<MultibindingDeclaration> multibindingDeclarations, ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations, ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations, DeclarationFormatter declarationFormatter) {
        AutoValue_BindingNode node = new AutoValue_BindingNode(component, delegate, multibindingDeclarations, optionalBindingDeclarations, subcomponentDeclarations);
        node.declarationFormatter = declarationFormatter;
        return node;
    }

    static final class Factory {
        private final DeclarationFormatter declarationFormatter;

        @Inject
        Factory(DeclarationFormatter declarationFormatter) {
            this.declarationFormatter = declarationFormatter;
        }

        public BindingNode forContributionBindings(ComponentPath component, ContributionBinding delegate, Iterable<MultibindingDeclaration> multibindingDeclarations, Iterable<OptionalBindingDeclaration> optionalBindingDeclarations, Iterable<SubcomponentDeclaration> subcomponentDeclarations) {
            return this.create(component, delegate, (ImmutableSet<MultibindingDeclaration>)ImmutableSet.copyOf(multibindingDeclarations), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.copyOf(optionalBindingDeclarations), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.copyOf(subcomponentDeclarations));
        }

        public BindingNode forMembersInjectionBinding(ComponentPath component, MembersInjectionBinding delegate) {
            return this.create(component, delegate, (ImmutableSet<MultibindingDeclaration>)ImmutableSet.of(), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.of(), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.of());
        }

        private BindingNode create(ComponentPath component, Binding delegate, ImmutableSet<MultibindingDeclaration> multibindingDeclarations, ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations, ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations) {
            return BindingNode.create(component, delegate, (ImmutableSet<MultibindingDeclaration>)multibindingDeclarations, (ImmutableSet<OptionalBindingDeclaration>)optionalBindingDeclarations, (ImmutableSet<SubcomponentDeclaration>)subcomponentDeclarations, this.declarationFormatter);
        }
    }
}

