/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.base.ProducerAnnotations;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DaggerExecutableElement;
import dagger.internal.codegen.model.DaggerType;
import dagger.internal.codegen.model.DaggerTypeElement;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;
import javax.inject.Inject;

public final class KeyFactory {
    private final XProcessingEnv processingEnv;
    private final CompilerOptions compilerOptions;
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    KeyFactory(XProcessingEnv processingEnv, CompilerOptions compilerOptions, InjectionAnnotations injectionAnnotations) {
        this.processingEnv = processingEnv;
        this.compilerOptions = compilerOptions;
        this.injectionAnnotations = injectionAnnotations;
    }

    private XType setOf(XType elementType) {
        return this.processingEnv.getDeclaredType(this.processingEnv.requireTypeElement((XTypeName)XTypeName.SET), new XType[]{elementType.boxed()});
    }

    private XType mapOf(XType keyType, XType valueType) {
        return this.processingEnv.getDeclaredType(this.processingEnv.requireTypeElement((XTypeName)XTypeName.MAP), new XType[]{keyType.boxed(), valueType.boxed()});
    }

    Key optionalOf(Key key) {
        return key.withType(DaggerType.from(this.optionalOf(key.type().xprocessing())));
    }

    private XType optionalOf(XType type) {
        return this.processingEnv.getDeclaredType(this.processingEnv.requireTypeElement((XTypeName)XTypeNames.JDK_OPTIONAL), new XType[]{type.boxed()});
    }

    private XType mapOfFrameworkType(XType keyType, XClassName frameworkClassName, XType valueType) {
        Preconditions.checkArgument((boolean)FrameworkTypes.MAP_VALUE_FRAMEWORK_TYPES.contains((Object)frameworkClassName));
        return this.mapOf(keyType, this.processingEnv.getDeclaredType(this.processingEnv.requireTypeElement((XTypeName)frameworkClassName), new XType[]{valueType.boxed()}));
    }

    Key forComponentMethod(XMethodElement componentMethod) {
        return this.forMethod(componentMethod, componentMethod.getReturnType());
    }

    Key forProductionComponentMethod(XMethodElement componentMethod) {
        XType returnType = componentMethod.getReturnType();
        XType keyType = XTypeNames.isFutureType(returnType) ? (XType)Iterables.getOnlyElement((Iterable)returnType.getTypeArguments()) : returnType;
        return this.forMethod(componentMethod, keyType);
    }

    Key forSubcomponentCreatorMethod(XMethodElement subcomponentCreatorMethod, XType declaredContainer) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared(declaredContainer));
        XMethodType resolvedMethod = subcomponentCreatorMethod.asMemberOf(declaredContainer);
        return this.forType(resolvedMethod.getReturnType());
    }

    public Key forSubcomponentCreator(XType creatorType) {
        return this.forType(creatorType);
    }

    public Key forProvidesMethod(XMethodElement method, XTypeElement contributingModule) {
        Preconditions.checkArgument((boolean)method.hasAnnotation(XTypeNames.PROVIDES));
        return this.forBindingMethod(method, contributingModule, Optional.of(XTypeNames.PROVIDER));
    }

    public Key forProducesMethod(XMethodElement method, XTypeElement contributingModule) {
        Preconditions.checkArgument((boolean)method.hasAnnotation(XTypeNames.PRODUCES));
        return this.forBindingMethod(method, contributingModule, Optional.of(XTypeNames.PRODUCER));
    }

    Key forBindsMethod(XMethodElement method, XTypeElement contributingModule) {
        Preconditions.checkArgument((boolean)method.hasAnnotation(XTypeNames.BINDS));
        return this.forBindingMethod(method, contributingModule, Optional.empty());
    }

    Key forBindsOptionalOfMethod(XMethodElement method, XTypeElement contributingModule) {
        Preconditions.checkArgument((boolean)method.hasAnnotation(XTypeNames.BINDS_OPTIONAL_OF));
        return this.forBindingMethod(method, contributingModule, Optional.empty());
    }

    private Key forBindingMethod(XMethodElement method, XTypeElement contributingModule, Optional<XClassName> frameworkClassName) {
        XMethodType methodType = method.asMemberOf(contributingModule.getType());
        ContributionType contributionType = ContributionType.fromBindingElement((XElement)method);
        XType returnType = methodType.getReturnType();
        if (frameworkClassName.isPresent() && frameworkClassName.get().equals((Object)XTypeNames.PRODUCER)) {
            SetType setType;
            if (XTypeNames.isFutureType(returnType)) {
                returnType = (XType)Iterables.getOnlyElement((Iterable)returnType.getTypeArguments());
            } else if (contributionType.equals((Object)ContributionType.SET_VALUES) && SetType.isSet(returnType) && XTypeNames.isFutureType((setType = SetType.from(returnType)).elementType())) {
                returnType = this.setOf(XTypes.unwrapType(setType.elementType()));
            }
        }
        XType keyType = this.bindingMethodKeyType(returnType, method, contributionType, frameworkClassName);
        Key key = this.forMethod(method, keyType);
        return contributionType.equals((Object)ContributionType.UNIQUE) ? key : key.withMultibindingContributionIdentifier(DaggerTypeElement.from(contributingModule), DaggerExecutableElement.from((XExecutableElement)method));
    }

    Key forMultibindsMethod(XMethodElement method, XMethodType methodType) {
        XType returnType = method.getReturnType();
        XType keyType = MapType.isMap(returnType) ? this.mapOfFrameworkType(MapType.from(returnType).keyType(), XTypeNames.PROVIDER, MapType.from(returnType).valueType()) : returnType;
        return this.forMethod(method, keyType);
    }

    private XType bindingMethodKeyType(XType returnType, XMethodElement method, ContributionType contributionType, Optional<XClassName> frameworkClassName) {
        switch (contributionType) {
            case UNIQUE: {
                return returnType;
            }
            case SET: {
                return this.setOf(returnType);
            }
            case MAP: {
                Optional<XType> mapKeyType = MapKeys.getMapKey((XElement)method).map(MapKeys::mapKeyType);
                Preconditions.checkState((boolean)mapKeyType.isPresent(), (String)"Missing map key annotation for method: %s#%s. That method was annotated with: %s. If a map key annotation is included in that list, it means Dagger wasn't able to detect that it was a map key because the dependency is missing from the classpath of the current build. To fix, add a dependency for the map key to the current build. For more details, see https://github.com/google/dagger/issues/3133#issuecomment-1002790894.", (Object)method.getEnclosingElement(), (Object)method, method.getAllAnnotations().stream().map(XAnnotations::toString).collect(DaggerStreams.toImmutableList()));
                return frameworkClassName.isPresent() && this.compilerOptions.useFrameworkTypeInMapMultibindingContributionKey() ? this.mapOfFrameworkType(mapKeyType.get(), frameworkClassName.get(), returnType) : this.mapOf(mapKeyType.get(), returnType);
            }
            case SET_VALUES: {
                Preconditions.checkArgument((boolean)SetType.isSet(returnType), (String)"%s is not a Set", (Object)returnType);
                return returnType;
            }
        }
        throw new AssertionError();
    }

    Key forDelegateBinding(DelegateDeclaration delegateDeclaration, XClassName frameworkType) {
        return delegateDeclaration.contributionType().equals((Object)ContributionType.MAP) && this.compilerOptions.useFrameworkTypeInMapMultibindingContributionKey() ? this.wrapMapValue(delegateDeclaration.key(), frameworkType) : delegateDeclaration.key();
    }

    private Key forMethod(XMethodElement method, XType keyType) {
        return this.forQualifiedType(this.injectionAnnotations.getQualifier((XElement)method), keyType);
    }

    public Key forInjectConstructorWithResolvedType(XType type) {
        return this.forType(type);
    }

    Key forType(XType type) {
        return Key.builder(DaggerType.from(type)).build();
    }

    public Key forMembersInjectedType(XType type) {
        return this.forType(type);
    }

    Key forQualifiedType(Optional<XAnnotation> qualifier, XType type) {
        return Key.builder(DaggerType.from(type.boxed())).qualifier(qualifier.map(DaggerAnnotation::from)).build();
    }

    public Key forProductionExecutor() {
        return Key.builder(DaggerType.from(this.processingEnv.requireType((XTypeName)XTypeNames.EXECUTOR))).qualifier(DaggerAnnotation.from(ProducerAnnotations.productionQualifier(this.processingEnv))).build();
    }

    public Key forProductionImplementationExecutor() {
        return Key.builder(DaggerType.from(this.processingEnv.requireType((XTypeName)XTypeNames.EXECUTOR))).qualifier(DaggerAnnotation.from(ProducerAnnotations.productionImplementationQualifier(this.processingEnv))).build();
    }

    public Key forProductionComponentMonitor() {
        return this.forType(this.processingEnv.requireType((XTypeName)XTypeNames.PRODUCTION_COMPONENT_MONITOR));
    }

    public Key unwrapMapValueType(Key key) {
        MapType mapType;
        if (MapType.isMap(key) && !(mapType = MapType.from(key)).isRawType() && mapType.valuesAreFrameworkType()) {
            return key.withType(DaggerType.from(this.mapOf(mapType.keyType(), mapType.unwrappedFrameworkValueType())));
        }
        return key;
    }

    private Key wrapMapValue(Key key, XClassName frameworkClassName) {
        MapType mapType;
        Preconditions.checkArgument((boolean)FrameworkTypes.MAP_VALUE_FRAMEWORK_TYPES.contains((Object)frameworkClassName));
        if (MapType.isMap(key) && !(mapType = MapType.from(key)).isRawType() && !mapType.valuesAreTypeOf(frameworkClassName)) {
            Preconditions.checkState((!mapType.valuesAreFrameworkType() ? 1 : 0) != 0);
            XTypeElement frameworkTypeElement = this.processingEnv.findTypeElement((XTypeName)frameworkClassName);
            if (frameworkTypeElement == null) {
                return key;
            }
            XType wrappedValueType = this.processingEnv.getDeclaredType(frameworkTypeElement, new XType[]{mapType.valueType()});
            return key.withType(DaggerType.from(this.mapOf(mapType.keyType(), wrappedValueType)));
        }
        return key;
    }

    Optional<Key> unwrapOptional(Key key) {
        if (!OptionalType.isOptional(key)) {
            return Optional.empty();
        }
        XType optionalValueType = OptionalType.from(key).valueType();
        return Optional.of(key.withType(DaggerType.from(RequestKinds.extractKeyType(optionalValueType))));
    }
}

