/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.bindinggraphvalidation.PackageNameCompressor;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.BindingGraphPlugin;
import dagger.internal.codegen.model.DaggerProcessingEnv;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.validation.DiagnosticMessageGenerator;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.tools.Diagnostic;

final class CompositeBindingGraphPlugin
extends ValidationBindingGraphPlugin {
    private final ImmutableSet<ValidationBindingGraphPlugin> plugins;
    private final DiagnosticMessageGenerator.Factory messageGeneratorFactory;
    private final Map<BindingGraph.ComponentNode, String> errorMessages = new HashMap<BindingGraph.ComponentNode, String>();

    @AssistedInject
    CompositeBindingGraphPlugin(@Assisted ImmutableSet<ValidationBindingGraphPlugin> plugins, DiagnosticMessageGenerator.Factory messageGeneratorFactory) {
        this.plugins = plugins;
        this.messageGeneratorFactory = messageGeneratorFactory;
    }

    @Override
    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        AggregatingDiagnosticReporter aggregatingDiagnosticReporter = new AggregatingDiagnosticReporter(bindingGraph, diagnosticReporter, this.messageGeneratorFactory.create(bindingGraph));
        this.plugins.forEach(plugin -> {
            aggregatingDiagnosticReporter.setCurrentPlugin(plugin.pluginName());
            plugin.visitGraph(bindingGraph, aggregatingDiagnosticReporter);
            if (plugin.visitFullGraphRequested(bindingGraph)) {
                this.requestVisitFullGraph(bindingGraph);
            }
        });
        if (this.visitFullGraphRequested(bindingGraph)) {
            this.errorMessages.put(bindingGraph.rootComponentNode(), aggregatingDiagnosticReporter.getMessage());
        } else {
            aggregatingDiagnosticReporter.report();
        }
    }

    @Override
    public void revisitFullGraph(BindingGraph prunedGraph, BindingGraph fullGraph, DiagnosticReporter diagnosticReporter) {
        AggregatingDiagnosticReporter aggregatingDiagnosticReporter = new AggregatingDiagnosticReporter(fullGraph, diagnosticReporter, this.errorMessages.get(prunedGraph.rootComponentNode()), this.messageGeneratorFactory.create(fullGraph));
        this.plugins.stream().filter(plugin -> plugin.visitFullGraphRequested(prunedGraph)).forEach(plugin -> {
            aggregatingDiagnosticReporter.setCurrentPlugin(plugin.pluginName());
            plugin.revisitFullGraph(prunedGraph, fullGraph, aggregatingDiagnosticReporter);
        });
        aggregatingDiagnosticReporter.report();
    }

    @Override
    public void init(DaggerProcessingEnv processingEnv, Map<String, String> options) {
        this.plugins.forEach(plugin -> plugin.init(processingEnv, options));
    }

    @Override
    public void onPluginEnd() {
        this.plugins.forEach(BindingGraphPlugin::onPluginEnd);
    }

    @Override
    public Set<String> supportedOptions() {
        return (Set)this.plugins.stream().flatMap(plugin -> plugin.supportedOptions().stream()).collect(DaggerStreams.toImmutableSet());
    }

    @Override
    public String pluginName() {
        return "Dagger/Validation";
    }

    private static final class AggregatingDiagnosticReporter
    extends DiagnosticReporter {
        private final DiagnosticReporter delegate;
        private final BindingGraph graph;
        private final StringBuilder messageBuilder = new StringBuilder("\n");
        private final DiagnosticMessageGenerator messageGenerator;
        private Optional<Diagnostic.Kind> mergedDiagnosticKind = Optional.empty();
        private String currentPluginName = null;

        AggregatingDiagnosticReporter(BindingGraph graph, DiagnosticReporter delegate, DiagnosticMessageGenerator messageGenerator) {
            this.graph = graph;
            this.delegate = delegate;
            this.messageGenerator = messageGenerator;
        }

        AggregatingDiagnosticReporter(BindingGraph graph, DiagnosticReporter delegate, String baseMessage, DiagnosticMessageGenerator messageGenerator) {
            this.graph = graph;
            this.delegate = delegate;
            this.messageGenerator = messageGenerator;
            this.messageBuilder.append(baseMessage);
        }

        void setCurrentPlugin(String pluginName) {
            this.currentPluginName = pluginName;
        }

        void report() {
            if (this.mergedDiagnosticKind.isPresent()) {
                this.delegate.reportComponent(this.mergedDiagnosticKind.get(), this.graph.rootComponentNode(), PackageNameCompressor.compressPackagesInMessage(this.messageBuilder.toString()));
            }
        }

        String getMessage() {
            return this.messageBuilder.toString();
        }

        @Override
        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String message) {
            this.addMessage(diagnosticKind, message);
            this.messageGenerator.appendComponentPathUnlessAtRoot(this.messageBuilder, componentNode);
        }

        @Override
        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String message) {
            this.addMessage(diagnosticKind, String.format("%s%s", message, this.messageGenerator.getMessage(binding)));
        }

        @Override
        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String message) {
            this.addMessage(diagnosticKind, String.format("%s%s", message, this.messageGenerator.getMessage(dependencyEdge)));
        }

        @Override
        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String message) {
            if (XElements.transitivelyEncloses((XElement)this.graph.rootComponentNode().componentPath().currentComponent().xprocessing(), (XElement)childFactoryMethodEdge.factoryMethod().xprocessing())) {
                this.delegate.reportSubcomponentFactoryMethod(diagnosticKind, childFactoryMethodEdge, message);
            } else {
                this.addMessage(diagnosticKind, String.format("[%s] %s", ElementFormatter.elementToString((XElement)childFactoryMethodEdge.factoryMethod().xprocessing()), message));
            }
        }

        private void addMessage(Diagnostic.Kind diagnosticKind, String message) {
            Preconditions.checkNotNull((Object)((Object)diagnosticKind));
            Preconditions.checkNotNull((Object)message);
            Preconditions.checkState((this.currentPluginName != null ? 1 : 0) != 0);
            if (this.mergedDiagnosticKind.isPresent()) {
                this.messageBuilder.append("\n\n");
            }
            this.mergeDiagnosticKind(diagnosticKind);
            this.messageBuilder.append(String.format("\u001b[1;31m[%s]\u001b[0m ", this.currentPluginName));
            this.messageBuilder.append(message);
        }

        private void mergeDiagnosticKind(Diagnostic.Kind diagnosticKind) {
            Preconditions.checkArgument((diagnosticKind != Diagnostic.Kind.MANDATORY_WARNING ? 1 : 0) != 0, (Object)"Dagger plugins should not be issuing mandatory warnings");
            if (!this.mergedDiagnosticKind.isPresent()) {
                this.mergedDiagnosticKind = Optional.of(diagnosticKind);
                return;
            }
            Diagnostic.Kind current = this.mergedDiagnosticKind.get();
            this.mergedDiagnosticKind = current == Diagnostic.Kind.ERROR || diagnosticKind == Diagnostic.Kind.ERROR ? Optional.of(Diagnostic.Kind.ERROR) : (current == Diagnostic.Kind.WARNING || diagnosticKind == Diagnostic.Kind.WARNING ? Optional.of(Diagnostic.Kind.WARNING) : (current == Diagnostic.Kind.NOTE || diagnosticKind == Diagnostic.Kind.NOTE ? Optional.of(Diagnostic.Kind.NOTE) : Optional.of(Diagnostic.Kind.OTHER)));
        }
    }

    @AssistedFactory
    static interface Factory {
        public CompositeBindingGraphPlugin create(ImmutableSet<ValidationBindingGraphPlugin> var1);
    }
}

