/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.Declaration;
import dagger.internal.codegen.binding.DeclarationFormatter;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.bindinggraphvalidation.AutoValue_DuplicateBindingsValidator_BindingWithoutComponent;
import dagger.internal.codegen.bindinggraphvalidation.AutoValue_DuplicateBindingsValidator_KeyWithTypeEquivalence;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.ComponentPath;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DaggerElement;
import dagger.internal.codegen.model.DaggerTypeElement;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class DuplicateBindingsValidator
extends ValidationBindingGraphPlugin {
    private static final Comparator<Binding> BY_LENGTH_OF_COMPONENT_PATH = Comparator.comparing(binding -> binding.componentPath().components().size());
    private final DeclarationFormatter declarationFormatter;
    private final CompilerOptions compilerOptions;

    @Inject
    DuplicateBindingsValidator(DeclarationFormatter declarationFormatter, CompilerOptions compilerOptions) {
        this.declarationFormatter = declarationFormatter;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public String pluginName() {
        return "Dagger/DuplicateBindings";
    }

    @Override
    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        HashSet reportedDuplicateBindingSets = new HashSet();
        this.duplicateBindingSets(bindingGraph).forEach(duplicateBindings -> {
            if (reportedDuplicateBindingSets.add(duplicateBindings.keySet())) {
                this.reportErrors((ImmutableSetMultimap<BindingWithoutComponent, Binding>)duplicateBindings, bindingGraph, diagnosticReporter);
            }
        });
    }

    private ImmutableSet<ImmutableSetMultimap<BindingWithoutComponent, Binding>> duplicateBindingSets(BindingGraph bindingGraph) {
        return (ImmutableSet)this.groupBindingsByKey(bindingGraph).stream().flatMap(bindings -> DuplicateBindingsValidator.mutuallyVisibleSubsets((Set<Binding>)bindings).stream()).map(BindingWithoutComponent::index).filter(duplicates -> duplicates.keySet().size() > 1).collect(DaggerStreams.toImmutableSet());
    }

    private ImmutableSet<ImmutableSet<Binding>> groupBindingsByKey(BindingGraph bindingGraph) {
        return DuplicateBindingsValidator.valueSetsForEachKey((Multimap)bindingGraph.bindings().stream().filter(binding -> !binding.kind().equals((Object)BindingKind.MEMBERS_INJECTION)).collect(DaggerStreams.toImmutableSetMultimap(binding -> KeyWithTypeEquivalence.forKey(binding.key(), (Equivalence<XType>)(this.compilerOptions.ignoreProvisionKeyWildcards() ? XTypes.equivalenceIgnoringVariance() : XTypes.equivalence())), binding -> binding)));
    }

    private static ImmutableSet<ImmutableSet<Binding>> mutuallyVisibleSubsets(Set<Binding> duplicateBindings) {
        ImmutableListMultimap bindingsByComponentPath = Multimaps.index(duplicateBindings, Binding::componentPath);
        ImmutableSetMultimap.Builder mutuallyVisibleBindings = ImmutableSetMultimap.builder();
        bindingsByComponentPath.asMap().forEach((componentPath, bindings) -> {
            mutuallyVisibleBindings.putAll(componentPath, (Iterable)bindings);
            ComponentPath ancestor = componentPath;
            while (!ancestor.atRoot()) {
                ancestor = ancestor.parent();
                ImmutableList bindingsInAncestor = bindingsByComponentPath.get((Object)ancestor);
                mutuallyVisibleBindings.putAll(componentPath, (Iterable)bindingsInAncestor);
            }
        });
        return DuplicateBindingsValidator.valueSetsForEachKey(mutuallyVisibleBindings.build());
    }

    private void reportErrors(ImmutableSetMultimap<BindingWithoutComponent, Binding> duplicateBindings, BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        if (DuplicateBindingsValidator.explicitBindingConfictsWithInject((ImmutableSet<BindingWithoutComponent>)duplicateBindings.keySet())) {
            this.compilerOptions.explicitBindingConflictsWithInjectValidationType().diagnosticKind().ifPresent(diagnosticKind -> this.reportExplicitBindingConflictsWithInject((ImmutableCollection<Binding>)duplicateBindings.values(), diagnosticReporter, (Diagnostic.Kind)((Object)diagnosticKind), bindingGraph.rootComponentNode()));
            return;
        }
        this.reportDuplicateBindings((ImmutableCollection<Binding>)duplicateBindings.values(), bindingGraph, diagnosticReporter);
    }

    private static boolean explicitBindingConfictsWithInject(ImmutableSet<BindingWithoutComponent> duplicateBindings) {
        ImmutableMultiset bindingKinds = Multimaps.index(duplicateBindings, BindingWithoutComponent::bindingKind).keys();
        return bindingKinds.count((Object)BindingKind.INJECTION) == 1 && bindingKinds.size() == 2;
    }

    private void reportExplicitBindingConflictsWithInject(ImmutableCollection<Binding> duplicateBindings, DiagnosticReporter diagnosticReporter, Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode rootComponent) {
        Binding injectBinding = DuplicateBindingsValidator.rootmostBindingWithKind(k -> k.equals((Object)BindingKind.INJECTION), duplicateBindings);
        Binding explicitBinding = DuplicateBindingsValidator.rootmostBindingWithKind(k -> !k.equals((Object)BindingKind.INJECTION), duplicateBindings);
        StringBuilder message = new StringBuilder().append(explicitBinding.key()).append(" is bound multiple times:").append(this.formatWithComponentPath(injectBinding)).append(this.formatWithComponentPath(explicitBinding)).append("\nThis condition was never validated before, and will soon be an error. See https://dagger.dev/conflicting-inject.");
        if (this.compilerOptions.experimentalDaggerErrorMessages()) {
            diagnosticReporter.reportComponent(diagnosticKind, rootComponent, message.toString());
        } else {
            diagnosticReporter.reportBinding(diagnosticKind, explicitBinding, message.toString());
        }
    }

    private String formatWithComponentPath(Binding binding) {
        return String.format("\n%s%s [%s]", "    ", this.declarationFormatter.format(((BindingNode)binding).delegate()), binding.componentPath());
    }

    private void reportDuplicateBindings(ImmutableCollection<Binding> duplicateBindings, BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        StringBuilder message = new StringBuilder();
        Binding oneBinding = (Binding)duplicateBindings.asList().get(0);
        ImmutableSet multibindings = (ImmutableSet)duplicateBindings.stream().filter(binding -> binding.kind().isMultibinding()).collect(DaggerStreams.toImmutableSet());
        if (multibindings.isEmpty()) {
            message.append(oneBinding.key()).append(" is bound multiple times:");
            this.formatDeclarations(message, 2, (Iterable<? extends Declaration>)this.declarations(graph, duplicateBindings));
        } else {
            Binding oneMultibinding = (Binding)multibindings.asList().get(0);
            message.append(oneMultibinding.key()).append(" has incompatible bindings or declarations:\n");
            message.append("    ").append(this.multibindingTypeString(oneMultibinding)).append(" bindings and declarations:");
            this.formatDeclarations(message, 2, (Iterable<? extends Declaration>)this.declarations(graph, (ImmutableCollection<Binding>)multibindings));
            ImmutableSet uniqueBindingDeclarations = (ImmutableSet)duplicateBindings.stream().filter(binding -> !binding.kind().isMultibinding()).flatMap(binding -> this.declarations(graph, (Binding)binding).stream()).filter(declaration -> !(declaration instanceof MultibindingDeclaration)).collect(DaggerStreams.toImmutableSet());
            if (!uniqueBindingDeclarations.isEmpty()) {
                message.append('\n').append("    ").append("Unique bindings and declarations:");
                this.formatDeclarations(message, 2, (Iterable<? extends Declaration>)uniqueBindingDeclarations);
            }
        }
        if (this.compilerOptions.experimentalDaggerErrorMessages()) {
            message.append(String.format("\n%sin component: [%s]", "    ", oneBinding.componentPath()));
            diagnosticReporter.reportComponent(Diagnostic.Kind.ERROR, graph.rootComponentNode(), message.toString());
        } else {
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, oneBinding, message.toString());
        }
    }

    private void formatDeclarations(StringBuilder builder, int indentLevel, Iterable<? extends Declaration> bindingDeclarations) {
        this.declarationFormatter.formatIndentedList(builder, ImmutableList.copyOf(bindingDeclarations), indentLevel);
    }

    private ImmutableSet<Declaration> declarations(BindingGraph graph, ImmutableCollection<Binding> bindings) {
        return (ImmutableSet)bindings.stream().flatMap(binding -> this.declarations(graph, (Binding)binding).stream()).distinct().sorted(Declaration.COMPARATOR).collect(DaggerStreams.toImmutableSet());
    }

    private ImmutableSet<Declaration> declarations(BindingGraph graph, Binding binding) {
        ImmutableSet.Builder declarations = ImmutableSet.builder();
        BindingNode bindingNode = (BindingNode)binding;
        bindingNode.associatedDeclarations().forEach(arg_0 -> ((ImmutableSet.Builder)declarations).add(arg_0));
        if (this.declarationFormatter.canFormat(bindingNode.delegate())) {
            declarations.add((Object)bindingNode.delegate());
        } else {
            graph.requestedBindings(binding).stream().flatMap(requestedBinding -> this.declarations(graph, (Binding)requestedBinding).stream()).forEach(arg_0 -> ((ImmutableSet.Builder)declarations).add(arg_0));
        }
        return declarations.build();
    }

    private String multibindingTypeString(Binding multibinding) {
        switch (multibinding.kind()) {
            case MULTIBOUND_MAP: {
                return "Map";
            }
            case MULTIBOUND_SET: {
                return "Set";
            }
        }
        throw new AssertionError(multibinding);
    }

    private static <E> ImmutableSet<ImmutableSet<E>> valueSetsForEachKey(Multimap<?, E> multimap) {
        return (ImmutableSet)multimap.asMap().values().stream().map(ImmutableSet::copyOf).collect(DaggerStreams.toImmutableSet());
    }

    private static Binding rootmostBindingWithKind(Predicate<BindingKind> bindingKindPredicate, ImmutableCollection<Binding> bindings) {
        return bindings.stream().filter(b -> bindingKindPredicate.test(b.kind())).min(BY_LENGTH_OF_COMPONENT_PATH).get();
    }

    @AutoValue
    static abstract class KeyWithTypeEquivalence {
        KeyWithTypeEquivalence() {
        }

        abstract Optional<DaggerAnnotation> qualifier();

        abstract Equivalence.Wrapper<XType> wrappedType();

        abstract Optional<Key.MultibindingContributionIdentifier> multibindingContributionIdentifier();

        private static KeyWithTypeEquivalence forKey(Key key, Equivalence<XType> typeEquivalence) {
            return new AutoValue_DuplicateBindingsValidator_KeyWithTypeEquivalence(key.qualifier(), (Equivalence.Wrapper<XType>)typeEquivalence.wrap((Object)key.type().xprocessing()), key.multibindingContributionIdentifier());
        }
    }

    @AutoValue
    static abstract class BindingWithoutComponent {
        BindingWithoutComponent() {
        }

        abstract BindingKind bindingKind();

        abstract Key bindingKey();

        abstract Optional<XElement> bindingElement();

        abstract Optional<XTypeElement> contributingModule();

        static ImmutableSetMultimap<BindingWithoutComponent, Binding> index(Set<Binding> bindings) {
            return (ImmutableSetMultimap)bindings.stream().collect(DaggerStreams.toImmutableSetMultimap(BindingWithoutComponent::forBinding, b -> b));
        }

        private static BindingWithoutComponent forBinding(Binding binding) {
            return new AutoValue_DuplicateBindingsValidator_BindingWithoutComponent(binding.kind(), binding.key(), binding.bindingElement().map(DaggerElement::xprocessing), binding.contributingModule().map(DaggerTypeElement::xprocessing));
        }
    }
}

