/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.langmodel;

import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.Optional;

public final class Accessibility {
    public static boolean isTypePubliclyAccessible(XType type) {
        return Accessibility.isTypeAccessibleFrom(type, Optional.empty());
    }

    public static boolean isTypeAccessibleFrom(XType type, String packageName) {
        return Accessibility.isTypeAccessibleFrom(type, Optional.of(packageName));
    }

    private static boolean isTypeAccessibleFrom(XType type, Optional<String> packageName) {
        if (XTypes.isNoType(type) || XTypes.isPrimitive(type) || XTypes.isNullType(type) || XTypes.isTypeVariable(type)) {
            return true;
        }
        if (XTypeKt.isArray((XType)type)) {
            return Accessibility.isTypeAccessibleFrom(XTypes.asArray(type).getComponentType(), packageName);
        }
        if (XTypes.isDeclared(type)) {
            XType enclosingType = XTypes.getEnclosingType(type);
            if (enclosingType != null && !Accessibility.isTypeAccessibleFrom(enclosingType, packageName)) {
                return false;
            }
            if (!Accessibility.isElementAccessibleFrom((XElement)type.getTypeElement(), packageName)) {
                return false;
            }
            return type.getTypeArguments().stream().allMatch(typeArgument -> Accessibility.isTypeAccessibleFrom(typeArgument, packageName));
        }
        if (XTypes.isWildcard(type)) {
            return type.extendsBound() == null || Accessibility.isTypeAccessibleFrom(type.extendsBound(), packageName);
        }
        throw new AssertionError((Object)String.format("%s should not be checked for accessibility", type));
    }

    public static boolean isElementPubliclyAccessible(XElement element) {
        return Accessibility.isElementAccessibleFrom(element, Optional.empty());
    }

    public static boolean isElementAccessibleFromOwnPackage(XElement element) {
        return Accessibility.isElementAccessibleFrom(element, Optional.of(element.getClosestMemberContainer().getClassName().packageName()));
    }

    public static boolean isElementAccessibleFrom(XElement element, String packageName) {
        return Accessibility.isElementAccessibleFrom(element, Optional.of(packageName));
    }

    private static boolean isElementAccessibleFrom(XElement element, Optional<String> packageName) {
        if (XElements.isPackage(element)) {
            return true;
        }
        if (XElementKt.isTypeElement((XElement)element)) {
            return XTypeElements.isNested(XElements.asTypeElement(element)) ? Accessibility.accessibleMember(element, packageName) : Accessibility.accessibleModifiers(element, packageName);
        }
        if (XElements.isExecutable(element) || XElementKt.isField((XElement)element)) {
            return Accessibility.accessibleMember(element, packageName);
        }
        throw new AssertionError();
    }

    private static boolean accessibleMember(XElement element, Optional<String> packageName) {
        return Accessibility.isElementAccessibleFrom(element.getEnclosingElement(), packageName) && Accessibility.accessibleModifiers(element, packageName);
    }

    private static boolean accessibleModifiers(XElement element, Optional<String> packageName) {
        if (XElements.isPublic(element)) {
            return true;
        }
        if (XElements.isPrivate(element)) {
            return false;
        }
        return packageName.isPresent() && element.getClosestMemberContainer().getClassName().packageName().contentEquals(packageName.get());
    }

    public static boolean isRawTypeAccessible(XType type, String requestingPackage) {
        return XTypes.isDeclared(type) ? Accessibility.isElementAccessibleFrom((XElement)type.getTypeElement(), requestingPackage) : Accessibility.isTypeAccessibleFrom(type, requestingPackage);
    }

    public static boolean isRawTypePubliclyAccessible(XType type) {
        return XTypes.isDeclared(type) ? Accessibility.isElementPubliclyAccessible((XElement)type.getTypeElement()) : Accessibility.isTypePubliclyAccessible(type);
    }

    public static TypeName accessibleTypeName(XType type, XClassName requestingClass, XProcessingEnv processingEnv) {
        if (Accessibility.isTypeAccessibleFrom(type, requestingClass.getPackageName())) {
            return type.getTypeName();
        }
        if (XTypes.isDeclared(type) && Accessibility.isRawTypeAccessible(type, requestingClass.getPackageName())) {
            return type.getRawType().getTypeName();
        }
        return TypeName.OBJECT;
    }

    private Accessibility() {
    }
}

