/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import javax.inject.Inject;

final class AssistedProcessingStep
extends TypeCheckingProcessingStep<XExecutableParameterElement> {
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    AssistedProcessingStep(InjectionAnnotations injectionAnnotations) {
        this.injectionAnnotations = injectionAnnotations;
    }

    public ImmutableSet<XClassName> annotationClassNames() {
        return ImmutableSet.of((Object)XTypeNames.ASSISTED);
    }

    @Override
    protected void process(XExecutableParameterElement assisted, ImmutableSet<XClassName> annotations) {
        new AssistedValidator().validate(assisted).printMessagesTo(this.messager);
    }

    private boolean isAssistedInjectConstructor(XExecutableElement executableElement) {
        return XElementKt.isConstructor((XElement)executableElement) && executableElement.hasAnnotation(XTypeNames.ASSISTED_INJECT);
    }

    private boolean isAssistedFactoryCreateMethod(XExecutableElement executableElement) {
        if (XElementKt.isMethod((XElement)executableElement)) {
            XTypeElement enclosingElement = XElements.closestEnclosingTypeElement((XElement)executableElement);
            return AssistedInjectionAnnotations.isAssistedFactoryType((XElement)enclosingElement) && AssistedInjectionAnnotations.assistedFactoryMethod(enclosingElement).equals((Object)executableElement);
        }
        return false;
    }

    private boolean isKotlinDataClassCopyMethod(XExecutableElement executableElement) {
        return XElementKt.isMethod((XElement)executableElement) && XElements.getSimpleName((XElement)XElements.asMethod((XElement)executableElement)).contentEquals("copy") && XElements.closestEnclosingTypeElement((XElement)executableElement.getEnclosingElement()).isDataClass();
    }

    private final class AssistedValidator {
        private AssistedValidator() {
        }

        ValidationReport validate(XExecutableParameterElement assisted) {
            ValidationReport.Builder report = ValidationReport.about((XElement)assisted);
            XExecutableElement enclosingElement = assisted.getEnclosingElement();
            if (!(AssistedProcessingStep.this.isAssistedInjectConstructor(enclosingElement) || AssistedProcessingStep.this.isAssistedFactoryCreateMethod(enclosingElement) || AssistedProcessingStep.this.isKotlinDataClassCopyMethod(enclosingElement))) {
                report.addError("@Assisted parameters can only be used within an @AssistedInject-annotated constructor.", (XElement)assisted);
            }
            AssistedProcessingStep.this.injectionAnnotations.getQualifiers((XElement)assisted).forEach(qualifier -> report.addError("Qualifiers cannot be used with @Assisted parameters.", (XElement)assisted, (XAnnotation)qualifier));
            return report.build();
        }
    }
}

