/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.AnnotationExpression;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeNameKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public class AnnotationCreatorGenerator
extends SourceFileGenerator<XTypeElement> {
    private static final XClassName AUTO_ANNOTATION = XClassName.get((String)"com.google.auto.value", (String[])new String[]{"AutoAnnotation"});

    @Inject
    AnnotationCreatorGenerator(XFiler filer, XProcessingEnv processingEnv) {
        super(filer, processingEnv);
    }

    @Override
    public XElement originatingElement(XTypeElement annotationType) {
        return annotationType;
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(XTypeElement annotationType) {
        XClassName generatedTypeName = AnnotationExpression.getAnnotationCreatorClassName(annotationType);
        TypeSpec.Builder annotationCreatorBuilder = TypeSpec.classBuilder((ClassName)XTypeNameKt.toJavaPoet((XClassName)generatedTypeName)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        for (XTypeElement annotationElement : this.annotationsToCreate(annotationType)) {
            annotationCreatorBuilder.addMethod(this.buildCreateMethod(generatedTypeName, annotationElement));
        }
        return ImmutableList.of((Object)annotationCreatorBuilder);
    }

    private MethodSpec buildCreateMethod(XClassName generatedTypeName, XTypeElement annotationElement) {
        String createMethodName = AnnotationExpression.createMethodName(annotationElement);
        MethodSpec.Builder createMethod = MethodSpec.methodBuilder((String)createMethodName).addAnnotation(XTypeNameKt.toJavaPoet((XClassName)AUTO_ANNOTATION)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(annotationElement.getType().getTypeName());
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (XMethodElement annotationMember : annotationElement.getDeclaredMethods()) {
            String parameterName = XElements.getSimpleName((XElement)annotationMember);
            XTypeName parameterType = this.maybeRewrapKClass(annotationMember.getReturnType()).asTypeName();
            createMethod.addParameter(XTypeNameKt.toJavaPoet((XTypeName)parameterType), parameterName, new Modifier[0]);
            parameters.add((Object)CodeBlock.of((String)"$L", (Object[])new Object[]{parameterName}));
        }
        XClassName autoAnnotationClass = generatedTypeName.peerClass("AutoAnnotation_" + generatedTypeName.getSimpleName() + "_" + createMethodName);
        createMethod.addStatement("return new $T($L)", new Object[]{XTypeNameKt.toJavaPoet((XClassName)autoAnnotationClass), CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)parameters.build())});
        return createMethod.build();
    }

    protected Set<XTypeElement> annotationsToCreate(XTypeElement annotationElement) {
        return AnnotationCreatorGenerator.nestedAnnotationElements(annotationElement, new LinkedHashSet<XTypeElement>());
    }

    @CanIgnoreReturnValue
    private static Set<XTypeElement> nestedAnnotationElements(XTypeElement annotationElement, Set<XTypeElement> annotationElements) {
        if (annotationElements.add(annotationElement)) {
            for (XMethodElement method : annotationElement.getDeclaredMethods()) {
                XType returnType = method.getReturnType();
                XTypeElement maybeAnnotationType = XTypeKt.isArray((XType)returnType) ? XTypes.asArray(returnType).getComponentType().getTypeElement() : returnType.getTypeElement();
                if (maybeAnnotationType == null || !maybeAnnotationType.isAnnotationClass()) continue;
                AnnotationCreatorGenerator.nestedAnnotationElements(maybeAnnotationType, annotationElements);
            }
        }
        return annotationElements;
    }

    private XType maybeRewrapKClass(XType type) {
        return XTypeKt.isArray((XType)type) ? XConverters.getProcessingEnv((XType)type).getArrayType(this.maybeRewrapKClass(XTypes.asArray(type).getComponentType())) : (XTypes.isTypeOf(type, XTypeNames.KCLASS) ? XTypes.rewrapType(type, XTypeNames.CLASS) : type);
    }
}

