/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.DelegateBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;

final class DelegatingFrameworkInstanceCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final DelegateBinding binding;
    private final ComponentImplementation componentImplementation;
    private final ComponentRequestRepresentations componentRequestRepresentations;

    @AssistedInject
    DelegatingFrameworkInstanceCreationExpression(@Assisted DelegateBinding binding, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations, CompilerOptions compilerOptions) {
        this.binding = (DelegateBinding)Preconditions.checkNotNull((Object)binding);
        this.componentImplementation = componentImplementation;
        this.componentRequestRepresentations = componentRequestRepresentations;
    }

    @Override
    public CodeBlock creationExpression() {
        DependencyRequest dependency = (DependencyRequest)Iterables.getOnlyElement(this.binding.dependencies());
        return CodeBlocks.cast(this.componentRequestRepresentations.getDependencyExpression(BindingRequest.bindingRequest(dependency.key(), this.binding.frameworkType()), this.componentImplementation.shardImplementation(this.binding).name()).codeBlock(), this.binding.frameworkType().frameworkClassName());
    }

    @AssistedFactory
    static interface Factory {
        public DelegatingFrameworkInstanceCreationExpression create(DelegateBinding var1);
    }
}

