/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.ProductionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.GwtCompatibility;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public final class ProducerFactoryGenerator
extends SourceFileGenerator<ProductionBinding> {
    private final CompilerOptions compilerOptions;
    private final SourceFiles sourceFiles;

    @Inject
    ProducerFactoryGenerator(XFiler filer, XProcessingEnv processingEnv, CompilerOptions compilerOptions, SourceFiles sourceFiles) {
        super(filer, processingEnv);
        this.compilerOptions = compilerOptions;
        this.sourceFiles = sourceFiles;
    }

    @Override
    public XElement originatingElement(ProductionBinding binding) {
        return binding.bindingElement().get();
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(ProductionBinding binding) {
        Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        FactoryFields factoryFields = FactoryFields.create(binding);
        TypeSpec.Builder factoryBuilder = TypeSpec.classBuilder((ClassName)XConverters.toJavaPoet((XClassName)SourceFiles.generatedClassNameForBinding(binding))).superclass((TypeName)ParameterizedTypeName.get((ClassName)XConverters.toJavaPoet((XClassName)XTypeNames.ABSTRACT_PRODUCES_METHOD_PRODUCER), (TypeName[])new TypeName[]{this.callProducesMethodParameter((ProductionBinding)binding).type, XConverters.toJavaPoet((XTypeName)binding.contributedType().asTypeName())})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariables((Iterable)SourceFiles.bindingTypeElementTypeVariableNames(binding).stream().map(typeName -> (TypeVariableName)XConverters.toJavaPoet((XTypeName)typeName)).collect(DaggerStreams.toImmutableList())).addFields((Iterable)factoryFields.getAll().stream().filter(field -> !field.equals((Object)factoryFields.executorField)).filter(field -> !field.equals((Object)factoryFields.monitorField)).collect(DaggerStreams.toImmutableList())).addMethod(this.constructorMethod(binding, factoryFields)).addMethod(this.staticCreateMethod(binding, factoryFields)).addMethod(this.collectDependenciesMethod(binding, factoryFields)).addMethod(this.callProducesMethod(binding, factoryFields));
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(arg_0 -> ((TypeSpec.Builder)factoryBuilder).addAnnotation(arg_0));
        return ImmutableList.of((Object)factoryBuilder);
    }

    private MethodSpec constructorMethod(ProductionBinding binding, FactoryFields factoryFields) {
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        constructorBuilder.addStatement("super($N, $L, $N)", new Object[]{factoryFields.monitorField, this.producerTokenConstruction(SourceFiles.generatedClassNameForBinding(binding), binding), factoryFields.executorField});
        factoryFields.getAll().forEach(field -> {
            constructorBuilder.addParameter(field.type, field.name, new Modifier[0]);
            if (!field.equals((Object)factoryFields.executorField) && !field.equals((Object)factoryFields.monitorField)) {
                if (XTypeNames.rawJavaTypeName(field.type).equals((Object)XConverters.toJavaPoet((XClassName)XTypeNames.PRODUCER))) {
                    constructorBuilder.addStatement("this.$1N = $2T.nonCancellationPropagatingViewOf($1N)", new Object[]{field, XConverters.toJavaPoet((XClassName)XTypeNames.PRODUCERS)});
                } else {
                    constructorBuilder.addStatement("this.$1N = $1N", new Object[]{field});
                }
            }
        });
        return constructorBuilder.build();
    }

    private MethodSpec staticCreateMethod(ProductionBinding binding, FactoryFields factoryFields) {
        List params = this.constructorMethod((ProductionBinding)binding, (FactoryFields)factoryFields).parameters;
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(XConverters.toJavaPoet((XTypeName)SourceFiles.parameterizedGeneratedTypeNameForBinding(binding))).addTypeVariables((Iterable)SourceFiles.bindingTypeElementTypeVariableNames(binding).stream().map(typeName -> (TypeVariableName)XConverters.toJavaPoet((XTypeName)typeName)).collect(DaggerStreams.toImmutableList())).addParameters((Iterable)params).addStatement("return new $T($L)", new Object[]{XConverters.toJavaPoet((XTypeName)SourceFiles.parameterizedGeneratedTypeNameForBinding(binding)), CodeBlocks.parameterNames(params)}).build();
    }

    public MethodSpec collectDependenciesMethod(ProductionBinding binding, FactoryFields factoryFields) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"collectDependencies").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED});
        ImmutableList<DependencyRequest> asyncDependencies = ProducerFactoryGenerator.asyncDependencies(binding);
        switch (asyncDependencies.size()) {
            case 0: {
                return methodBuilder.returns(XConverters.toJavaPoet((XTypeName)XTypeNames.listenableFutureOf(XTypeNames.UNIT_VOID_CLASS))).addStatement("return $T.<$T>immediateFuture(null)", new Object[]{XConverters.toJavaPoet((XClassName)XTypeNames.FUTURES), XConverters.toJavaPoet((XTypeName)XTypeNames.UNIT_VOID_CLASS)}).build();
            }
            case 1: {
                DependencyRequest asyncDependency = (DependencyRequest)Iterables.getOnlyElement(asyncDependencies);
                FieldSpec asyncDependencyField = factoryFields.get(asyncDependency);
                return methodBuilder.returns(XConverters.toJavaPoet((XTypeName)XTypeNames.listenableFutureOf(ProducerFactoryGenerator.asyncDependencyType(asyncDependency)))).addStatement("return $L", new Object[]{this.producedCodeBlock(asyncDependency, asyncDependencyField)}).build();
            }
        }
        CodeBlock.Builder argAssignments = CodeBlock.builder();
        ImmutableList.Builder argNames = ImmutableList.builder();
        for (DependencyRequest asyncDependency : asyncDependencies) {
            FieldSpec asyncDependencyField = factoryFields.get(asyncDependency);
            argNames.add((Object)CodeBlock.of((String)"$L", (Object[])new Object[]{ProducerFactoryGenerator.dependencyFutureName(asyncDependency)}));
            argAssignments.addStatement("$T $L = $L", new Object[]{XConverters.toJavaPoet((XTypeName)XTypeNames.listenableFutureOf(ProducerFactoryGenerator.asyncDependencyType(asyncDependency))), ProducerFactoryGenerator.dependencyFutureName(asyncDependency), this.producedCodeBlock(asyncDependency, asyncDependencyField)});
        }
        return methodBuilder.returns(XConverters.toJavaPoet((XTypeName)XTypeNames.listenableFutureOf(XTypeNames.listOf(XTypeName.ANY_OBJECT)))).addCode(argAssignments.build()).addStatement("return $T.<$T>allAsList($L)", new Object[]{XConverters.toJavaPoet((XClassName)XTypeNames.FUTURES), XConverters.toJavaPoet((XTypeName)XTypeName.ANY_OBJECT), CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)argNames.build())}).build();
    }

    private CodeBlock producedCodeBlock(DependencyRequest request, FieldSpec field) {
        return request.kind() == RequestKind.PRODUCED ? CodeBlock.of((String)"$T.createFutureProduced($N.get())", (Object[])new Object[]{XConverters.toJavaPoet((XClassName)XTypeNames.PRODUCERS), field}) : CodeBlock.of((String)"$N.get()", (Object[])new Object[]{field});
    }

    private MethodSpec callProducesMethod(ProductionBinding binding, FactoryFields factoryFields) {
        XTypeName contributedTypeName = binding.contributedType().asTypeName();
        ParameterSpec parameter = this.callProducesMethodParameter(binding);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"callProducesMethod").returns(XConverters.toJavaPoet((XTypeName)XTypeNames.listenableFutureOf(contributedTypeName))).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addExceptions((Iterable)XElements.asMethod(binding.bindingElement().get()).getThrownTypes().stream().map(XType::getTypeName).collect(DaggerStreams.toImmutableList())).addParameter(parameter);
        ImmutableList<DependencyRequest> asyncDependencies = ProducerFactoryGenerator.asyncDependencies(binding);
        ImmutableList.Builder parameterCodeBlocks = ImmutableList.builder();
        for (DependencyRequest dependency : binding.explicitDependencies()) {
            if (ProducerFactoryGenerator.isAsyncDependency(dependency)) {
                if (asyncDependencies.size() > 1) {
                    XTypeName dependencyType = ProducerFactoryGenerator.asyncDependencyType(dependency);
                    int argIndex = asyncDependencies.indexOf((Object)dependency);
                    parameterCodeBlocks.add((Object)CodeBlock.of((String)"($T) $N.get($L)", (Object[])new Object[]{XConverters.toJavaPoet((XTypeName)dependencyType), parameter, argIndex}));
                    continue;
                }
                parameterCodeBlocks.add((Object)CodeBlock.of((String)"$N", (Object[])new Object[]{parameter}));
                continue;
            }
            parameterCodeBlocks.add((Object)this.sourceFiles.frameworkTypeUsageStatement(CodeBlock.of((String)"$N", (Object[])new Object[]{factoryFields.get(dependency)}), dependency.kind()));
        }
        if (asyncDependencies.size() > 1) {
            methodBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0]));
        }
        CodeBlock moduleCodeBlock = CodeBlock.of((String)"$L.$L($L)", (Object[])new Object[]{factoryFields.moduleField.isPresent() ? ((FieldSpec)((FactoryFields)factoryFields).moduleField.get()).name : CodeBlock.of((String)"$T", (Object[])new Object[]{XConverters.toJavaPoet((XClassName)binding.bindingTypeElement().get().asClassName())}), XElements.getSimpleName(binding.bindingElement().get()), CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)parameterCodeBlocks.build())});
        switch (ProductionKind.fromProducesMethod(XElements.asMethod(binding.bindingElement().get())).ordinal()) {
            case 0: {
                methodBuilder.addStatement("return $T.<$T>immediateFuture($L)", new Object[]{XConverters.toJavaPoet((XClassName)XTypeNames.FUTURES), XConverters.toJavaPoet((XTypeName)contributedTypeName), moduleCodeBlock});
                break;
            }
            case 1: {
                methodBuilder.addStatement("return $L", new Object[]{moduleCodeBlock});
                break;
            }
            case 2: {
                methodBuilder.addStatement("return $T.allAsSet($L)", new Object[]{XConverters.toJavaPoet((XClassName)XTypeNames.PRODUCERS), moduleCodeBlock});
            }
        }
        return methodBuilder.build();
    }

    private ParameterSpec callProducesMethodParameter(ProductionBinding binding) {
        ImmutableList<DependencyRequest> asyncDependencies = ProducerFactoryGenerator.asyncDependencies(binding);
        switch (asyncDependencies.size()) {
            case 0: {
                return ParameterSpec.builder((TypeName)XConverters.toJavaPoet((XTypeName)XTypeNames.UNIT_VOID_CLASS), (String)"ignoredVoidArg", (Modifier[])new Modifier[0]).build();
            }
            case 1: {
                DependencyRequest asyncDependency = (DependencyRequest)Iterables.getOnlyElement(asyncDependencies);
                String argName = XElements.getSimpleName(asyncDependency.requestElement().get().xprocessing());
                return ParameterSpec.builder((TypeName)XConverters.toJavaPoet((XTypeName)ProducerFactoryGenerator.asyncDependencyType(asyncDependency)), (String)(argName.equals("module") ? "moduleArg" : argName), (Modifier[])new Modifier[0]).build();
            }
        }
        return ParameterSpec.builder((TypeName)XConverters.toJavaPoet((XTypeName)XTypeNames.listOf(XTypeName.ANY_OBJECT)), (String)"args", (Modifier[])new Modifier[0]).build();
    }

    private static ImmutableList<DependencyRequest> asyncDependencies(ProductionBinding binding) {
        return (ImmutableList)binding.dependencies().stream().filter(ProducerFactoryGenerator::isAsyncDependency).collect(DaggerStreams.toImmutableList());
    }

    private CodeBlock producerTokenConstruction(XClassName generatedTypeName, ProductionBinding binding) {
        CodeBlock producerTokenArgs = this.compilerOptions.writeProducerNameInToken() ? CodeBlock.of((String)"$S", (Object[])new Object[]{String.format("%s#%s", binding.bindingTypeElement().get().getClassName(), XElements.getSimpleName(binding.bindingElement().get()))}) : CodeBlock.of((String)"$T.class", (Object[])new Object[]{XConverters.toJavaPoet((XClassName)generatedTypeName)});
        return CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{XConverters.toJavaPoet((XClassName)XTypeNames.PRODUCER_TOKEN), producerTokenArgs});
    }

    private static String dependencyFutureName(DependencyRequest dependency) {
        return XElements.getSimpleName(dependency.requestElement().get().xprocessing()) + "Future";
    }

    private static boolean isAsyncDependency(DependencyRequest dependency) {
        switch (dependency.kind()) {
            case INSTANCE: 
            case PRODUCED: {
                return true;
            }
        }
        return false;
    }

    private static XTypeName asyncDependencyType(DependencyRequest dependency) {
        XTypeName keyName = dependency.key().type().xprocessing().asTypeName();
        switch (dependency.kind()) {
            case INSTANCE: {
                return keyName;
            }
            case PRODUCED: {
                return XTypeNames.producedOf(keyName);
            }
        }
        throw new AssertionError();
    }

    @Override
    protected ImmutableSet<AnnotationSpecs.Suppression> warningSuppressions() {
        return ImmutableSet.of((Object)((Object)AnnotationSpecs.Suppression.FUTURE_RETURN_VALUE_IGNORED));
    }

    private static final class FactoryFields {
        private final Optional<FieldSpec> moduleField;
        private final FieldSpec monitorField;
        private final FieldSpec executorField;
        private final ImmutableMap<DependencyRequest, FieldSpec> frameworkFields;

        static FactoryFields create(ProductionBinding binding) {
            UniqueNameSet nameSet = new UniqueNameSet();
            Optional<FieldSpec> moduleField = binding.requiresModuleInstance() ? Optional.of(FactoryFields.createField(binding.bindingTypeElement().get().getType().asTypeName(), nameSet.getUniqueName("module"))) : Optional.empty();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            SourceFiles.generateBindingFieldsForDependencies(binding).forEach((dependency, field) -> builder.put(dependency, (Object)FactoryFields.createField(field.type(), nameSet.getUniqueName(field.name()))));
            return new FactoryFields(binding, moduleField, (ImmutableMap<DependencyRequest, FieldSpec>)builder.buildOrThrow());
        }

        private static FieldSpec createField(XTypeName type, String name) {
            return FieldSpec.builder((TypeName)XConverters.toJavaPoet((XTypeName)type), (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        }

        private FactoryFields(ProductionBinding binding, Optional<FieldSpec> moduleField, ImmutableMap<DependencyRequest, FieldSpec> frameworkFields) {
            this.moduleField = moduleField;
            this.monitorField = (FieldSpec)frameworkFields.get((Object)binding.monitorRequest());
            this.executorField = (FieldSpec)frameworkFields.get((Object)binding.executorRequest());
            this.frameworkFields = frameworkFields;
        }

        FieldSpec get(DependencyRequest request) {
            return (FieldSpec)this.frameworkFields.get((Object)request);
        }

        ImmutableList<FieldSpec> getAll() {
            return this.moduleField.isPresent() ? ImmutableList.builder().add((Object)this.moduleField.get()).addAll((Iterable)this.frameworkFields.values()).build() : this.frameworkFields.values().asList();
        }
    }

    private static enum ProductionKind {
        IMMEDIATE,
        FUTURE,
        SET_OF_FUTURE;


        static ProductionKind fromProducesMethod(XMethodElement producesMethod) {
            if (XTypeNames.isFutureType(producesMethod.getReturnType())) {
                return FUTURE;
            }
            if (ContributionType.fromBindingElement((XElement)producesMethod).equals((Object)ContributionType.SET_VALUES) && XTypeNames.isFutureType(SetType.from(producesMethod.getReturnType()).elementType())) {
                return SET_OF_FUTURE;
            }
            return IMMEDIATE;
        }
    }
}

