/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.InjectionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.writing.MembersInjectionMethods;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.Optional;

final class SimpleMethodRequestRepresentation
extends RequestRepresentation {
    private static final ImmutableSet<BindingKind> VALID_BINDING_KINDS = ImmutableSet.of((Object)((Object)BindingKind.INJECTION), (Object)((Object)BindingKind.ASSISTED_INJECTION), (Object)((Object)BindingKind.PROVISION));
    private final CompilerOptions compilerOptions;
    private final XProcessingEnv processingEnv;
    private final ContributionBinding binding;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final MembersInjectionMethods membersInjectionMethods;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final ComponentImplementation.ShardImplementation shardImplementation;

    @AssistedInject
    SimpleMethodRequestRepresentation(@Assisted ContributionBinding binding, MembersInjectionMethods membersInjectionMethods, CompilerOptions compilerOptions, XProcessingEnv processingEnv, ComponentRequestRepresentations componentRequestRepresentations, ComponentRequirementExpressions componentRequirementExpressions, ComponentImplementation componentImplementation) {
        this.compilerOptions = compilerOptions;
        this.processingEnv = processingEnv;
        this.binding = binding;
        Preconditions.checkArgument((boolean)VALID_BINDING_KINDS.contains((Object)binding.kind()));
        Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        this.componentRequestRepresentations = componentRequestRepresentations;
        this.membersInjectionMethods = membersInjectionMethods;
        this.componentRequirementExpressions = componentRequirementExpressions;
        this.shardImplementation = componentImplementation.shardImplementation(binding);
    }

    @Override
    Expression getDependencyExpression(XClassName requestingClass) {
        return this.requiresInjectionMethod(requestingClass) ? this.invokeInjectionMethod(requestingClass) : this.invokeMethod(requestingClass);
    }

    private Expression invokeMethod(XClassName requestingClass) {
        CodeBlock invocation;
        CodeBlock arguments = CodeBlocks.makeParametersCodeBlock(InjectionMethods.ProvisionMethod.invokeArguments(this.binding, request -> this.dependencyArgument((DependencyRequest)request, requestingClass).codeBlock(), this.shardImplementation::getUniqueFieldNameForAssistedParam));
        XElement bindingElement = this.binding.bindingElement().get();
        XTypeElement bindingTypeElement = this.binding.bindingTypeElement().get();
        if (XElementKt.isConstructor((XElement)bindingElement)) {
            invocation = CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{XConverters.toJavaPoet((XTypeName)this.constructorTypeName(requestingClass)), arguments});
        } else if (XElementKt.isMethod((XElement)bindingElement)) {
            Optional<CodeBlock> requiredModuleInstance = this.moduleReference(requestingClass);
            CodeBlock module = requiredModuleInstance.isPresent() ? requiredModuleInstance.get() : (bindingTypeElement.isKotlinObject() && !bindingTypeElement.isCompanionObject() ? CodeBlock.of((String)"$T.INSTANCE", (Object[])new Object[]{bindingTypeElement.getClassName()}) : CodeBlock.of((String)"$T", (Object[])new Object[]{bindingTypeElement.getClassName()}));
            invocation = CodeBlock.of((String)"$L.$L($L)", (Object[])new Object[]{module, XElements.asMethod(bindingElement).getJvmName(), arguments});
        } else {
            throw new AssertionError((Object)("Unexpected binding element: " + bindingElement));
        }
        return Expression.create(this.simpleMethodReturnType(), invocation);
    }

    private XTypeName constructorTypeName(XClassName requestingClass) {
        XType type = this.binding.key().type().xprocessing();
        return type.getTypeArguments().stream().allMatch(t -> Accessibility.isTypeAccessibleFrom(t, requestingClass.getPackageName())) ? type.asTypeName() : type.getRawType().asTypeName();
    }

    private Expression invokeInjectionMethod(XClassName requestingClass) {
        return this.injectMembers(InjectionMethods.ProvisionMethod.invoke(this.binding, request -> this.dependencyArgument((DependencyRequest)request, requestingClass).codeBlock(), this.shardImplementation::getUniqueFieldNameForAssistedParam, requestingClass, this.moduleReference(requestingClass), this.compilerOptions), requestingClass);
    }

    private Expression dependencyArgument(DependencyRequest dependency, XClassName requestingClass) {
        return this.componentRequestRepresentations.getDependencyArgumentExpression(dependency, requestingClass);
    }

    private Expression injectMembers(CodeBlock instance, XClassName requestingClass) {
        if (!SimpleMethodRequestRepresentation.hasInjectionSites(this.binding)) {
            return Expression.create(this.simpleMethodReturnType(), instance);
        }
        if (XProcessingEnvs.isPreJava8SourceVersion(this.processingEnv) && !this.binding.key().type().xprocessing().getTypeArguments().isEmpty()) {
            XType keyType = this.binding.key().type().xprocessing();
            XTypeName keyTypeName = keyType.asTypeName();
            XTypeName rawKeyTypeName = keyType.getRawType().asTypeName();
            instance = CodeBlock.of((String)"($T) ($T) $L", (Object[])new Object[]{XConverters.toJavaPoet((XTypeName)keyTypeName), XConverters.toJavaPoet((XTypeName)rawKeyTypeName), instance});
        }
        return this.membersInjectionMethods.getInjectExpression(this.binding.key(), instance, requestingClass);
    }

    private Optional<CodeBlock> moduleReference(XClassName requestingClass) {
        return this.binding.requiresModuleInstance() ? this.binding.contributingModule().map(XTypeElement::getType).map(ComponentRequirement::forModule).map(module -> this.componentRequirementExpressions.getExpression((ComponentRequirement)module, requestingClass)) : Optional.empty();
    }

    private XType simpleMethodReturnType() {
        return this.binding.contributedPrimitiveType().orElse(this.binding.key().type().xprocessing());
    }

    private boolean requiresInjectionMethod(XClassName requestingClass) {
        XExecutableElement executableElement = XElements.asExecutable(this.binding.bindingElement().get());
        return SimpleMethodRequestRepresentation.hasInjectionSites(this.binding) || this.binding.shouldCheckForNull(this.compilerOptions) || !Accessibility.isElementAccessibleFrom((XElement)executableElement, requestingClass.getPackageName()) || executableElement.getParameters().stream().map(XVariableElement::getType).anyMatch(type -> !Accessibility.isRawTypeAccessible(type, requestingClass.getPackageName()));
    }

    private static boolean hasInjectionSites(ContributionBinding binding) {
        switch (binding.kind()) {
            case INJECTION: {
                return !((InjectionBinding)binding).injectionSites().isEmpty();
            }
            case ASSISTED_INJECTION: {
                return !((AssistedInjectionBinding)binding).injectionSites().isEmpty();
            }
            case PROVISION: {
                return false;
            }
        }
        throw new AssertionError((Object)("Unexpected binding kind: " + (Object)((Object)binding.kind())));
    }

    @AssistedFactory
    static interface Factory {
        public SimpleMethodRequestRepresentation create(ContributionBinding var1);
    }
}

