/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.producers.Producer;
import dagger.producers.internal.CancellableProducer;
import dagger.producers.internal.CancellationListener;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractProducer<T>
implements CancellableProducer<T> {
    private final AtomicBoolean requested = new AtomicBoolean();
    private final NonExternallyCancellableFuture<T> future = new NonExternallyCancellableFuture();

    protected AbstractProducer() {
    }

    protected abstract ListenableFuture<T> compute();

    @Override
    public final ListenableFuture<T> get() {
        if (this.requested.compareAndSet(false, true)) {
            this.future.setFuture(this.compute());
        }
        return this.future;
    }

    @Override
    public final void cancel(boolean mayInterruptIfRunning) {
        this.requested.set(true);
        this.future.doCancel(mayInterruptIfRunning);
    }

    @Override
    public Producer<T> newDependencyView() {
        return new NonCancellationPropagatingView();
    }

    @Override
    public Producer<T> newEntryPointView(CancellationListener cancellationListener) {
        NonCancellationPropagatingView result = new NonCancellationPropagatingView();
        result.addCancellationListener(cancellationListener);
        return result;
    }

    private static <T> ListenableFuture<T> nonCancellationPropagating(ListenableFuture<T> future) {
        if (future.isDone()) {
            return future;
        }
        NonCancellationPropagatingFuture<T> output = new NonCancellationPropagatingFuture<T>(future);
        future.addListener(output, MoreExecutors.directExecutor());
        return output;
    }

    private static final class NonExternallyCancellableFuture<T>
    extends AbstractFuture<T> {
        private NonExternallyCancellableFuture() {
        }

        public boolean setFuture(ListenableFuture<? extends T> future) {
            return super.setFuture(future);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        void doCancel(boolean mayInterruptIfRunning) {
            super.cancel(mayInterruptIfRunning);
        }
    }

    private final class NonCancellationPropagatingView
    implements Producer<T> {
        private final ListenableFuture<T> viewFuture;

        private NonCancellationPropagatingView() {
            this.viewFuture = AbstractProducer.nonCancellationPropagating((ListenableFuture)AbstractProducer.this.future);
        }

        @Override
        public ListenableFuture<T> get() {
            AbstractProducer.this.get();
            return this.viewFuture;
        }

        void addCancellationListener(final CancellationListener cancellationListener) {
            this.viewFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    if (NonCancellationPropagatingView.this.viewFuture.isCancelled()) {
                        boolean mayInterruptIfRunning = NonCancellationPropagatingView.this.viewFuture instanceof NonCancellationPropagatingFuture && ((NonCancellationPropagatingFuture)NonCancellationPropagatingView.this.viewFuture).interrupted();
                        cancellationListener.onProducerFutureCancelled(mayInterruptIfRunning);
                    }
                }
            }, MoreExecutors.directExecutor());
        }
    }

    private static final class NonCancellationPropagatingFuture<T>
    extends AbstractFuture<T>
    implements Runnable {
        private ListenableFuture<T> delegate;

        NonCancellationPropagatingFuture(ListenableFuture<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            ListenableFuture<T> localDelegate = this.delegate;
            if (localDelegate != null) {
                this.setFuture(localDelegate);
            }
        }

        protected String pendingToString() {
            ListenableFuture<T> localDelegate = this.delegate;
            if (localDelegate != null) {
                return "delegate=[" + localDelegate + "]";
            }
            return null;
        }

        protected void afterDone() {
            this.delegate = null;
        }

        public boolean interrupted() {
            return super.wasInterrupted();
        }
    }
}

