/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.internal.LazyClassKeyMap;
import dagger.producers.Produced;
import dagger.producers.internal.AbstractProducer;
import java.util.Map;
import java.util.concurrent.Executor;

public final class LazyMapOfProducedProducer<V>
extends AbstractProducer<Map<Class<?>, Produced<V>>> {
    AbstractProducer<Map<String, Produced<V>>> delegate;

    public static <V> LazyMapOfProducedProducer<V> of(AbstractProducer<Map<String, Produced<V>>> delegate) {
        return new LazyMapOfProducedProducer<V>(delegate);
    }

    private LazyMapOfProducedProducer(AbstractProducer<Map<String, Produced<V>>> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ListenableFuture<Map<Class<?>, Produced<V>>> compute() {
        return Futures.transform(this.delegate.compute(), (Function)new Function<Map<String, Produced<V>>, Map<Class<?>, Produced<V>>>(){

            public Map<Class<?>, Produced<V>> apply(Map<String, Produced<V>> classMap) {
                return LazyClassKeyMap.of(classMap);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }
}

