/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.internal.LazyClassKeyMap;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import java.util.Map;
import java.util.concurrent.Executor;

public final class LazyMapOfProducerProducer<V>
extends AbstractProducer<Map<Class<?>, Producer<V>>> {
    AbstractProducer<Map<String, Producer<V>>> delegate;

    public static <V> LazyMapOfProducerProducer<V> of(AbstractProducer<Map<String, Producer<V>>> delegate) {
        return new LazyMapOfProducerProducer<V>(delegate);
    }

    private LazyMapOfProducerProducer(AbstractProducer<Map<String, Producer<V>>> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ListenableFuture<Map<Class<?>, Producer<V>>> compute() {
        return Futures.transform(this.delegate.compute(), (Function)new Function<Map<String, Producer<V>>, Map<Class<?>, Producer<V>>>(){

            public Map<Class<?>, Producer<V>> apply(Map<String, Producer<V>> classMap) {
                return LazyClassKeyMap.of(classMap);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }
}

