/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.internal.LazyClassKeyMap;
import dagger.producers.internal.AbstractProducer;
import java.util.Map;
import java.util.concurrent.Executor;

public final class LazyMapProducer<V>
extends AbstractProducer<Map<Class<?>, V>> {
    AbstractProducer<Map<String, V>> delegate;

    public static <V> LazyMapProducer<V> of(AbstractProducer<Map<String, V>> delegate) {
        return new LazyMapProducer<V>(delegate);
    }

    private LazyMapProducer(AbstractProducer<Map<String, V>> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ListenableFuture<Map<Class<?>, V>> compute() {
        return Futures.transform(this.delegate.compute(), (Function)new Function<Map<String, V>, Map<Class<?>, V>>(){

            public Map<Class<?>, V> apply(Map<String, V> classMap) {
                return LazyClassKeyMap.of(classMap);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }
}

