/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.google.TestStringBiMapGenerator;
import java.util.LinkedHashMap;
import java.util.Map;

@GwtCompatible
public class BiMapGenerators {

    public static class ImmutableBiMapCopyOfGenerator
    extends TestStringBiMapGenerator {
        @Override
        protected BiMap<String, String> create(Map.Entry<String, String>[] entries) {
            LinkedHashMap builder = Maps.newLinkedHashMap();
            for (Map.Entry<String, String> entry : entries) {
                builder.put(entry.getKey(), entry.getValue());
            }
            return ImmutableBiMap.copyOf((Map)builder);
        }
    }

    public static class ImmutableBiMapGenerator
    extends TestStringBiMapGenerator {
        @Override
        protected BiMap<String, String> create(Map.Entry<String, String>[] entries) {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            for (Map.Entry<String, String> entry : entries) {
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return builder.build();
        }
    }
}

